/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.rocker.impl;

import com.fizzed.rocker.BindableRockerModel;
import com.fizzed.rocker.Rocker;
import com.fizzed.rocker.RockerOutputFactory;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.common.template.CachingTemplateEngine;
import io.vertx.ext.web.templ.rocker.RockerTemplateEngine;
import io.vertx.ext.web.templ.rocker.impl.VertxBufferOutput;
import java.util.Map;

public class RockerTemplateEngineImpl
extends CachingTemplateEngine<Void>
implements RockerTemplateEngine {
    public RockerTemplateEngineImpl() {
        super("rocker.html", 10000);
    }

    @Override
    public RockerTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public RockerTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    public void render(Map<String, Object> context, String templateFile, Handler<AsyncResult<Buffer>> handler) {
        try {
            String templatePath = this.adjustLocation(templateFile);
            BindableRockerModel model = Rocker.template((String)templatePath);
            context.forEach((k, v) -> {
                if (!k.startsWith("__")) {
                    model.bind(k, v);
                }
            });
            VertxBufferOutput output = (VertxBufferOutput)model.render((RockerOutputFactory)VertxBufferOutput.FACTORY);
            handler.handle((Object)Future.succeededFuture((Object)output.getBuffer()));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }
}

