/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.util;

import java.util.ArrayList;
import java.util.List;

public class ArgumentSplitter {
    private static final char argumentDelimiter = ',';
    private final String arguments;
    private List<String> argList = new ArrayList<String>();

    public static List<String> split(String arguments) {
        return new ArgumentSplitter(arguments).splitArguments();
    }

    private ArgumentSplitter(String arguments) {
        this.arguments = arguments;
    }

    private List<String> splitArguments() {
        int argLength = this.arguments.length();
        StringBuilder sb = new StringBuilder(argLength);
        boolean insideQuotas = false;
        int bracesBlock = 0;
        for (int i = 0; i < argLength; ++i) {
            char ch = this.arguments.charAt(i);
            if (ch == '\"' || ch == '\'') {
                insideQuotas = !insideQuotas;
            } else if (ch == '(') {
                ++bracesBlock;
            } else if (ch == ')') {
                --bracesBlock;
            } else if (ch == '[') {
                ++bracesBlock;
            } else if (ch == ']') {
                --bracesBlock;
            } else if (ch == ',' && !insideQuotas && bracesBlock == 0) {
                this.pushArg(sb);
                sb = new StringBuilder(argLength);
            }
            sb.append(ch);
        }
        this.pushArg(sb);
        return this.argList;
    }

    private void pushArg(StringBuilder sb) {
        this.argList.add(sb.toString().trim().replaceAll("^,", "").trim());
        sb = new StringBuilder(this.arguments.length());
    }
}

