/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.api.validation.ContainerDeserializer;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.SplitterCharContainerDeserializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@VertxGen
public enum ContainerSerializationStyle {
    csv(new String[]{"csv", "commaDelimited", "form", "simple", "matrix"}, new SplitterCharContainerDeserializer(Pattern.quote(","))),
    ssv(new String[]{"ssv", "spaceDelimited"}, new SplitterCharContainerDeserializer("\\s+")),
    psv(new String[]{"psv", "pipeDelimited"}, new SplitterCharContainerDeserializer(Pattern.quote("|"))),
    dsv(new String[]{"dsv", "dotDelimited", "label"}, new SplitterCharContainerDeserializer(Pattern.quote("."))),
    simple_exploded_object(new String[]{"simple_exploded_object"}, new ContainerDeserializer(){

        @Override
        public List<String> deserializeArray(String serialized) throws ValidationException {
            return null;
        }

        @Override
        public Map<String, String> deserializeObject(String serialized) throws ValidationException {
            String[] values;
            HashMap<String, String> result = new HashMap<String, String>();
            for (String value : values = serialized.split(Pattern.quote(","), -1)) {
                String[] values_internal = value.split("=", -1);
                if (values_internal[0].length() == 0) {
                    throw ValidationException.ValidationExceptionFactory.generateDeserializationError("DeserializationError: Empty key not allowed");
                }
                result.put(values_internal[0], values_internal[1]);
            }
            return result;
        }
    }),
    matrix_exploded_array(new String[]{"matrix_exploded_array"}, new ContainerDeserializer(){
        private final Pattern MATRIX_PARAMETER = Pattern.compile(";(?<key>[^;=]*)=(?<value>[^\\/\\;\\?\\:\\@\\&\\\"\\<\\>\\#\\%\\{\\}\\|\\\\\\^\\~\\[\\]\\`]*)");

        @Override
        public List<String> deserializeArray(String serialized) throws ValidationException {
            ArrayList<String> values = new ArrayList<String>();
            Matcher m = this.MATRIX_PARAMETER.matcher(serialized);
            while (m.find()) {
                values.add(URIDecoder.decodeURIComponent((String)m.group("value"), (boolean)false));
            }
            return values;
        }

        @Override
        public Map<String, String> deserializeObject(String serialized) throws ValidationException {
            return null;
        }
    });

    private ContainerDeserializer deserializer;
    private List<String> names;

    private ContainerSerializationStyle(String[] names, ContainerDeserializer deserializer) {
        this.names = Arrays.asList(names);
        this.deserializer = deserializer;
    }

    public ContainerDeserializer deserializer() {
        return this.deserializer;
    }

    public List<String> names() {
        return this.names;
    }

    public static ContainerSerializationStyle getContainerStyle(String s) {
        for (ContainerSerializationStyle style : ContainerSerializationStyle.values()) {
            if (!style.names().contains(s)) continue;
            return style;
        }
        return csv;
    }
}

