/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.OperationRequestConverter;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class OperationRequest {
    private JsonObject params;
    private MultiMap headers;
    private JsonObject user;
    private JsonObject extra;

    public OperationRequest() {
        this.init();
    }

    public OperationRequest(JsonObject json) {
        this.init();
        OperationRequestConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        JsonObject hdrs = json.getJsonObject("headers", null);
        if (hdrs != null) {
            this.headers = new CaseInsensitiveHeaders();
            for (Map.Entry entry : hdrs) {
                if (!(entry.getValue() instanceof String)) {
                    throw new IllegalStateException("Invalid type for message header value " + entry.getValue().getClass());
                }
                this.headers.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public OperationRequest(JsonObject params, MultiMap headers, JsonObject user, JsonObject extra) {
        this.params = params;
        this.headers = headers;
        this.user = user;
        this.extra = extra;
    }

    public OperationRequest(OperationRequest other) {
        this.params = other.getParams();
        this.headers = other.getHeaders();
        this.user = other.getUser();
        this.extra = other.getExtra();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OperationRequestConverter.toJson(this, json);
        if (this.headers != null) {
            JsonObject hJson = new JsonObject();
            this.headers.entries().forEach(entry -> hJson.put((String)entry.getKey(), (String)entry.getValue()));
            json.put("headers", hJson);
        }
        return json;
    }

    private void init() {
        this.params = new JsonObject();
        this.headers = MultiMap.caseInsensitiveMultiMap();
        this.user = null;
        this.extra = null;
    }

    public JsonObject getParams() {
        return this.params;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public JsonObject getUser() {
        return this.user;
    }

    public JsonObject getExtra() {
        return this.extra;
    }

    @Fluent
    public OperationRequest setParams(JsonObject params) {
        this.params = params;
        return this;
    }

    @Fluent
    public OperationRequest setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @Fluent
    public OperationRequest setUser(JsonObject user) {
        this.user = user;
        return this;
    }

    @Fluent
    public OperationRequest setExtra(JsonObject extra) {
        this.extra = extra;
        return this;
    }
}

