/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationMessage;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ValidationException;
import java.io.IOException;
import java.util.Set;

public class JsonTypeValidator
implements ParameterTypeValidator {
    JsonSchema schema;

    public JsonTypeValidator(JsonSchema schema) {
        this.schema = schema;
    }

    @Override
    public RequestParameter isValid(String value) throws ValidationException {
        try {
            if (value == null) {
                throw ValidationException.ValidationExceptionFactory.generateNotParsableJsonBodyException("Json should not be null");
            }
            Object node = value.length() == 0 ? JsonNodeFactory.instance.textNode("") : Json.mapper.readTree(value);
            Set errors = this.schema.validate((JsonNode)node);
            if (errors.size() == 0) {
                if (node.isArray()) {
                    return RequestParameter.create(new JsonArray(value));
                }
                if (node.isObject()) {
                    return RequestParameter.create(new JsonObject(value));
                }
                return RequestParameter.create(value);
            }
            ValidationMessage firstError = (ValidationMessage)errors.iterator().next();
            throw ValidationException.ValidationExceptionFactory.generateInvalidJsonBodyException(firstError.getPath(), value, firstError.getMessage());
        }
        catch (IOException e) {
            throw ValidationException.ValidationExceptionFactory.generateNotParsableJsonBodyException(e.getMessage());
        }
    }

    public static class JsonTypeValidatorFactory {
        public static JsonTypeValidator createJsonTypeValidator(JsonNode schema) {
            return new JsonTypeValidator(JsonSchemaFactory.getInstance().getSchema(schema));
        }

        public static JsonTypeValidator createJsonTypeValidator(String schema) {
            if (schema.length() != 0) {
                try {
                    return JsonTypeValidatorFactory.createJsonTypeValidator(Json.mapper.readTree(schema));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("schema provided is invalid: " + e);
                }
            }
            return null;
        }
    }
}

