/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.impl.RequestParameterImpl;
import io.vertx.ext.web.api.impl.RequestParametersImpl;
import io.vertx.ext.web.api.validation.CustomValidator;
import io.vertx.ext.web.api.validation.ParameterLocation;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ParameterValidationRule;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.ValidationHandler;
import io.vertx.ext.web.impl.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class BaseValidationHandler
implements ValidationHandler {
    private Map<String, ParameterValidationRule> pathParamsRules = new HashMap<String, ParameterValidationRule>();
    private Map<String, ParameterValidationRule> cookieParamsRules = new HashMap<String, ParameterValidationRule>();
    private ParameterTypeValidator cookieAdditionalPropertiesValidator;
    private String cookieAdditionalPropertiesObjectPropertyName;
    private Map<String, ParameterValidationRule> queryParamsRules;
    private ParameterTypeValidator queryAdditionalPropertiesValidator;
    private String queryAdditionalPropertiesObjectPropertyName;
    private Map<String, ParameterValidationRule> formParamsRules = new HashMap<String, ParameterValidationRule>();
    private Map<String, ParameterValidationRule> headerParamsRules;
    private ParameterTypeValidator entireBodyValidator;
    private Map<String, Pattern> multipartFileRules;
    private List<String> bodyFileRules;
    private List<CustomValidator> customValidators;
    protected boolean bodyRequired = false;

    protected BaseValidationHandler() {
        this.queryParamsRules = new HashMap<String, ParameterValidationRule>();
        this.headerParamsRules = new HashMap<String, ParameterValidationRule>();
        this.multipartFileRules = new HashMap<String, Pattern>();
        this.bodyFileRules = new ArrayList<String>();
        this.customValidators = new ArrayList<CustomValidator>();
    }

    public void handle(RoutingContext routingContext) {
        try {
            RequestParametersImpl parsedParameters = new RequestParametersImpl();
            parsedParameters.setPathParameters(this.validatePathParams(routingContext));
            parsedParameters.setQueryParameters(this.validateQueryParams(routingContext));
            parsedParameters.setHeaderParameters(this.validateHeaderParams(routingContext));
            parsedParameters.setCookieParameters(this.validateCookieParams(routingContext));
            for (CustomValidator customValidator : this.customValidators) {
                customValidator.validate(routingContext);
            }
            String contentType = routingContext.request().getHeader("Content-Type");
            if (contentType != null && contentType.length() != 0) {
                boolean isMultipart = contentType.contains("multipart/form-data");
                if (this.multipartFileRules.size() != 0 && !isMultipart) {
                    throw ValidationException.ValidationExceptionFactory.generateWrongContentTypeExpected(contentType, "multipart/form-data");
                }
                if (contentType.contains("application/x-www-form-urlencoded")) {
                    parsedParameters.setFormParameters(this.validateFormParams(routingContext));
                } else if (isMultipart) {
                    parsedParameters.setFormParameters(this.validateFormParams(routingContext));
                    this.validateFileUpload(routingContext);
                } else if (Utils.isJsonContentType((String)contentType) || Utils.isXMLContentType((String)contentType)) {
                    parsedParameters.setBody(this.validateEntireBody(routingContext));
                } else if (this.bodyRequired && !this.checkContentType(contentType)) {
                    throw ValidationException.ValidationExceptionFactory.generateWrongContentTypeExpected(contentType, null);
                }
            } else if (this.bodyRequired) {
                throw ValidationException.ValidationExceptionFactory.generateWrongContentTypeExpected(contentType, null);
            }
            if (routingContext.data().containsKey("parsedParameters")) {
                ((RequestParametersImpl)routingContext.get("parsedParameters")).merge(parsedParameters);
            } else {
                routingContext.put("parsedParameters", (Object)parsedParameters);
            }
            routingContext.next();
        }
        catch (ValidationException e) {
            routingContext.fail((Throwable)((Object)e));
        }
    }

    private Map<String, RequestParameter> validatePathParams(RoutingContext routingContext) throws ValidationException {
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        Map pathParams = routingContext.pathParams();
        for (ParameterValidationRule rule : this.pathParamsRules.values()) {
            String name = rule.getName();
            if (pathParams.containsKey(name)) {
                RequestParameter parsedParam = rule.validateSingleParam((String)pathParams.get(name));
                if (parsedParams.containsKey(parsedParam.getName())) {
                    parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(parsedParam.getName()));
                }
                parsedParams.put(parsedParam.getName(), parsedParam);
                continue;
            }
            throw ValidationException.ValidationExceptionFactory.generateNotFoundValidationException(name, ParameterLocation.PATH);
        }
        return parsedParams;
    }

    private Map<String, RequestParameter> validateCookieParams(RoutingContext routingContext) throws ValidationException {
        RequestParameter parsedParam;
        if (!routingContext.request().headers().contains("Cookie")) {
            return new HashMap<String, RequestParameter>();
        }
        QueryStringDecoder decoder = new QueryStringDecoder("/?" + routingContext.request().getHeader("Cookie"));
        HashMap cookies = new HashMap();
        for (Map.Entry e : decoder.parameters().entrySet()) {
            String string = ((String)e.getKey()).trim();
            if (cookies.containsKey(string)) {
                ((List)cookies.get(string)).addAll((Collection)e.getValue());
                continue;
            }
            cookies.put(string, e.getValue());
        }
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        for (ParameterValidationRule parameterValidationRule : this.cookieParamsRules.values()) {
            String name = parameterValidationRule.getName().trim();
            if (cookies.containsKey(name)) {
                List p = (List)cookies.remove(name);
                if (p.size() != 0) {
                    RequestParameter parsedParam2 = parameterValidationRule.validateArrayParam(p);
                    if (parsedParams.containsKey(parsedParam2.getName())) {
                        parsedParam2 = parsedParam2.merge((RequestParameter)parsedParams.get(parsedParam2.getName()));
                    }
                    parsedParams.put(parsedParam2.getName(), parsedParam2);
                    continue;
                }
                throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException(name + " can't be empty");
            }
            if (parameterValidationRule.parameterTypeValidator().getDefault() != null) {
                parsedParam = new RequestParameterImpl(name, parameterValidationRule.parameterTypeValidator().getDefault());
                if (parsedParams.containsKey(parsedParam.getName())) {
                    parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(parsedParam.getName()));
                }
                parsedParams.put(parsedParam.getName(), parsedParam);
                continue;
            }
            if (parameterValidationRule.isOptional()) continue;
            throw ValidationException.ValidationExceptionFactory.generateNotFoundValidationException(name, ParameterLocation.COOKIE);
        }
        if (this.cookieAdditionalPropertiesValidator != null) {
            for (Map.Entry entry : cookies.entrySet()) {
                try {
                    HashMap r = new HashMap();
                    r.put(entry.getKey(), this.cookieAdditionalPropertiesValidator.isValidCollection((List)entry.getValue()));
                    parsedParam = new RequestParameterImpl(this.cookieAdditionalPropertiesObjectPropertyName, r);
                    if (parsedParams.containsKey(this.cookieAdditionalPropertiesObjectPropertyName)) {
                        parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(this.cookieAdditionalPropertiesObjectPropertyName));
                    }
                    parsedParams.put(parsedParam.getName(), parsedParam);
                }
                catch (ValidationException ex) {
                    ex.setParameterName(this.cookieAdditionalPropertiesObjectPropertyName);
                    entry.setValue(entry.getValue());
                    throw ex;
                }
            }
        }
        return parsedParams;
    }

    private Map<String, RequestParameter> validateQueryParams(RoutingContext routingContext) throws ValidationException {
        RequestParameter parsedParam;
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        MultiMap queryParams = new CaseInsensitiveHeaders().addAll(routingContext.queryParams());
        for (ParameterValidationRule rule : this.queryParamsRules.values()) {
            String name = rule.getName();
            if (queryParams.contains(name)) {
                List p = queryParams.getAll(name);
                queryParams.remove(name);
                if (p.size() != 0) {
                    RequestParameter parsedParam2 = rule.validateArrayParam(p);
                    if (parsedParams.containsKey(parsedParam2.getName())) {
                        parsedParam2 = parsedParam2.merge((RequestParameter)parsedParams.get(parsedParam2.getName()));
                    }
                    parsedParams.put(parsedParam2.getName(), parsedParam2);
                    continue;
                }
                throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException(name + " can't be empty");
            }
            if (rule.parameterTypeValidator().getDefault() != null) {
                parsedParam = new RequestParameterImpl(name, rule.parameterTypeValidator().getDefault());
                if (parsedParams.containsKey(parsedParam.getName())) {
                    parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(parsedParam.getName()));
                }
                parsedParams.put(parsedParam.getName(), parsedParam);
                continue;
            }
            if (rule.isOptional()) continue;
            throw ValidationException.ValidationExceptionFactory.generateNotFoundValidationException(name, ParameterLocation.QUERY);
        }
        if (this.queryAdditionalPropertiesValidator != null) {
            for (Map.Entry e : queryParams.entries()) {
                try {
                    HashMap r = new HashMap();
                    r.put(e.getKey(), this.queryAdditionalPropertiesValidator.isValid((String)e.getValue()));
                    parsedParam = new RequestParameterImpl(this.queryAdditionalPropertiesObjectPropertyName, r);
                    if (parsedParams.containsKey(this.queryAdditionalPropertiesObjectPropertyName)) {
                        parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(this.queryAdditionalPropertiesObjectPropertyName));
                    }
                    parsedParams.put(parsedParam.getName(), parsedParam);
                }
                catch (ValidationException ex) {
                    ex.setParameterName(this.queryAdditionalPropertiesObjectPropertyName);
                    e.setValue(e.getValue());
                    throw ex;
                }
            }
        }
        return parsedParams;
    }

    private Map<String, RequestParameter> validateHeaderParams(RoutingContext routingContext) throws ValidationException {
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        MultiMap headersParams = routingContext.request().headers();
        for (ParameterValidationRule rule : this.headerParamsRules.values()) {
            String name = rule.getName();
            if (headersParams.contains(name)) {
                List p = headersParams.getAll(name);
                if (p.size() != 0) {
                    RequestParameter parsedParam = rule.validateArrayParam(p);
                    if (parsedParams.containsKey(parsedParam.getName())) {
                        parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(parsedParam.getName()));
                    }
                    parsedParams.put(parsedParam.getName(), parsedParam);
                    continue;
                }
                throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException(name + " can't be empty");
            }
            if (rule.parameterTypeValidator().getDefault() != null) {
                RequestParameter parsedParam = new RequestParameterImpl(name, rule.parameterTypeValidator().getDefault());
                if (parsedParams.containsKey(parsedParam.getName())) {
                    parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(parsedParam.getName()));
                }
                parsedParams.put(parsedParam.getName(), parsedParam);
                continue;
            }
            if (rule.isOptional()) continue;
            throw ValidationException.ValidationExceptionFactory.generateNotFoundValidationException(name, ParameterLocation.HEADER);
        }
        return parsedParams;
    }

    private Map<String, RequestParameter> validateFormParams(RoutingContext routingContext) throws ValidationException {
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        MultiMap formParams = routingContext.request().formAttributes();
        for (ParameterValidationRule rule : this.formParamsRules.values()) {
            String name = rule.getName();
            if (formParams.contains(name)) {
                List p = formParams.getAll(name);
                if (p.size() != 0) {
                    RequestParameter parsedParam = rule.validateArrayParam(p);
                    if (parsedParams.containsKey(parsedParam.getName())) {
                        parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(parsedParam.getName()));
                    }
                    parsedParams.put(parsedParam.getName(), parsedParam);
                    continue;
                }
                throw ValidationException.ValidationExceptionFactory.generateNotMatchValidationException(name + " can't be empty");
            }
            if (rule.parameterTypeValidator().getDefault() != null) {
                RequestParameter parsedParam = new RequestParameterImpl(name, rule.parameterTypeValidator().getDefault());
                if (parsedParams.containsKey(parsedParam.getName())) {
                    parsedParam = parsedParam.merge((RequestParameter)parsedParams.get(parsedParam.getName()));
                }
                parsedParams.put(parsedParam.getName(), parsedParam);
                continue;
            }
            if (rule.isOptional()) continue;
            throw ValidationException.ValidationExceptionFactory.generateNotFoundValidationException(name, ParameterLocation.BODY_FORM);
        }
        return parsedParams;
    }

    private boolean existFileUpload(Set<FileUpload> files, String name, Pattern contentType) {
        for (FileUpload f : files) {
            if (!f.name().equals(name) || !contentType.matcher(f.contentType()).matches()) continue;
            return true;
        }
        return false;
    }

    private void validateFileUpload(RoutingContext routingContext) throws ValidationException {
        Set fileUploads = routingContext.fileUploads();
        for (Map.Entry<String, Pattern> expectedFile : this.multipartFileRules.entrySet()) {
            if (this.existFileUpload(fileUploads, expectedFile.getKey(), expectedFile.getValue())) continue;
            throw ValidationException.ValidationExceptionFactory.generateFileNotFoundValidationException(expectedFile.getKey(), expectedFile.getValue().toString());
        }
    }

    private RequestParameter validateEntireBody(RoutingContext routingContext) throws ValidationException {
        if (this.entireBodyValidator != null) {
            return this.entireBodyValidator.isValid(routingContext.getBodyAsString());
        }
        return RequestParameter.create(null);
    }

    private boolean checkContentType(String contentType) {
        for (String ct : this.bodyFileRules) {
            if (!contentType.contains(ct)) continue;
            return true;
        }
        return false;
    }

    protected void addRule(ParameterValidationRule rule, ParameterLocation location) {
        switch (location) {
            case PATH: {
                this.addPathParamRule(rule);
                break;
            }
            case HEADER: {
                this.addHeaderParamRule(rule);
                break;
            }
            case COOKIE: {
                this.addCookieParamRule(rule);
                break;
            }
            case QUERY: {
                this.addQueryParamRule(rule);
                break;
            }
            case BODY_FORM: {
                this.addFormParamRule(rule);
            }
        }
    }

    protected void addPathParamRule(ParameterValidationRule rule) {
        if (!this.pathParamsRules.containsKey(rule.getName())) {
            this.pathParamsRules.put(rule.getName(), rule);
        }
    }

    protected void addCookieParamRule(ParameterValidationRule rule) {
        if (!this.cookieParamsRules.containsKey(rule.getName())) {
            this.cookieParamsRules.put(rule.getName(), rule);
        }
    }

    protected void addQueryParamRule(ParameterValidationRule rule) {
        if (!this.queryParamsRules.containsKey(rule.getName())) {
            this.queryParamsRules.put(rule.getName(), rule);
        }
    }

    protected void addFormParamRule(ParameterValidationRule rule) {
        if (!this.formParamsRules.containsKey(rule.getName())) {
            this.formParamsRules.put(rule.getName(), rule);
        }
        this.bodyRequired = true;
    }

    protected void addHeaderParamRule(ParameterValidationRule rule) {
        if (!this.headerParamsRules.containsKey(rule.getName())) {
            this.headerParamsRules.put(rule.getName(), rule);
        }
    }

    protected void addCustomValidator(CustomValidator customValidator) {
        this.customValidators.add(customValidator);
    }

    protected void addMultipartFileRule(String formName, String contentType) {
        if (!this.multipartFileRules.containsKey(formName)) {
            this.multipartFileRules.put(formName, Pattern.compile(contentType));
        }
        this.bodyRequired = true;
    }

    protected void addBodyFileRule(String contentType) {
        this.bodyFileRules.add(contentType);
        this.bodyRequired = true;
    }

    protected void setEntireBodyValidator(ParameterTypeValidator entireBodyValidator) {
        this.entireBodyValidator = entireBodyValidator;
        this.bodyRequired = true;
    }

    protected void setCookieAdditionalPropertyHandler(ParameterTypeValidator validator, String objectParameterName) {
        this.cookieAdditionalPropertiesValidator = validator;
        this.cookieAdditionalPropertiesObjectPropertyName = objectParameterName;
    }

    protected void setQueryAdditionalPropertyHandler(ParameterTypeValidator validator, String objectParameterName) {
        this.queryAdditionalPropertiesValidator = validator;
        this.queryAdditionalPropertiesObjectPropertyName = objectParameterName;
    }
}

