/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import io.swagger.v3.oas.models.parameters.Parameter;
import io.vertx.ext.web.api.contract.RouterFactoryException;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OpenAPI3PathResolver {
    String oasPath;
    List<Parameter> parameters;
    Pattern resolvedPattern;
    Map<String, String> mappedGroups;
    public static final Pattern OAS_PATH_PARAMETERS_PATTERN = Pattern.compile("\\{{1}[.;?*+]*([^\\{\\}.;?*+]+)[^\\}]*\\}{1}");
    public static final Pattern ILLEGAL_PATH_MATCHER = Pattern.compile("\\{[^\\/]*\\/[^\\/]*\\}");
    public static final String QUERY_REGEX_WITH_SLASH = "\\/?(?>\\??[^\\/]*)?";
    public static final String QUERY_REGEX_WITHOUT_SLASH = "(?>\\??[^\\/]*)?";

    public OpenAPI3PathResolver(String oasPath, List<Parameter> parameters) {
        this.oasPath = oasPath;
        this.parameters = parameters;
        this.mappedGroups = new HashMap<String, String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pattern solve() {
        this.parameters = this.parameters.stream().filter(parameter -> parameter.getIn().equals("path")).collect(Collectors.toList());
        if (ILLEGAL_PATH_MATCHER.matcher(this.oasPath).matches()) {
            throw new RouterFactoryException("Path template not supported", RouterFactoryException.ErrorType.INVALID_SPEC_PATH);
        }
        Matcher parametersMatcher = OAS_PATH_PARAMETERS_PATTERN.matcher(this.oasPath);
        if (!this.parameters.isEmpty() && parametersMatcher.find()) {
            StringBuilder regex = new StringBuilder();
            int lastMatchEnd = 0;
            boolean endSlash = this.oasPath.charAt(this.oasPath.length() - 1) == '/';
            parametersMatcher.reset();
            int i = 0;
            while (parametersMatcher.find()) {
                regex.append(Pattern.quote(this.oasPath.substring(lastMatchEnd, parametersMatcher.start())));
                lastMatchEnd = parametersMatcher.end();
                String paramName = parametersMatcher.group(1);
                Optional<Parameter> parameterOptional = this.parameters.stream().filter(p -> p.getName().equals(paramName)).findFirst();
                if (!parameterOptional.isPresent()) throw RouterFactoryException.createSpecInvalidException("Missing parameter description for parameter name: " + paramName);
                Parameter parameter2 = parameterOptional.get();
                String style = parameter2.getStyle() != null ? parameter2.getStyle().toString() : "simple";
                boolean explode = parameter2.getExplode() != null ? parameter2.getExplode() : false;
                boolean isObject = OpenApi3Utils.isParameterObjectOrAllOfType(parameter2);
                boolean isArray = OpenApi3Utils.isParameterArrayType(parameter2);
                String groupName = "p" + i;
                switch (style) {
                    case "simple": {
                        regex.append("(?<" + groupName + ">[^\\/\\;\\?\\:\\@\\&\\.\\\"\\<\\>\\#\\{\\}\\|\\\\\\^\\~\\[\\]\\`]*)?");
                        this.mappedGroups.put(groupName, paramName);
                        break;
                    }
                    case "label": {
                        Map<String, OpenApi3Utils.ObjectField> properties;
                        if (isObject && explode) {
                            properties = OpenApi3Utils.solveObjectParameters(parameter2.getSchema());
                            for (Map.Entry<String, OpenApi3Utils.ObjectField> entry : properties.entrySet()) {
                                groupName = "p" + i;
                                regex.append("\\.?" + entry.getKey() + "=(?<" + groupName + ">[^\\/\\;\\?\\:\\@\\=\\.\\&\\\"\\<\\>\\#\\{\\}\\|\\\\\\^\\~\\[\\]\\`]*)");
                                this.mappedGroups.put(groupName, entry.getKey());
                                ++i;
                            }
                            break;
                        }
                        regex.append("\\.?(?<" + groupName + ">[^\\/\\;\\?\\:\\@\\=\\&\\\"\\<\\>\\#\\{\\}\\|\\\\\\^\\~\\[\\]\\`]*)?");
                        this.mappedGroups.put(groupName, paramName);
                        break;
                    }
                    case "matrix": {
                        Map<String, OpenApi3Utils.ObjectField> properties;
                        if (isObject && explode) {
                            properties = OpenApi3Utils.solveObjectParameters(parameter2.getSchema());
                            for (Map.Entry<String, OpenApi3Utils.ObjectField> entry : properties.entrySet()) {
                                groupName = "p" + i;
                                regex.append("\\;" + entry.getKey() + "=(?<" + groupName + ">[^\\/\\;\\?\\:\\@\\=\\.\\&\\\"\\<\\>\\#\\{\\}\\|\\\\\\^\\~\\[\\]\\`]*)");
                                this.mappedGroups.put(groupName, entry.getKey());
                                ++i;
                            }
                            break;
                        }
                        if (isArray && explode) {
                            regex.append("(?<" + groupName + ">(?>;" + paramName + "=[^\\/\\;\\?\\:\\@\\&\\\"\\<\\>\\#\\{\\}\\|\\\\\\^\\~\\[\\]\\`]*)+)");
                            this.mappedGroups.put(groupName, paramName);
                            break;
                        }
                        regex.append(";" + paramName + "=(?<" + groupName + ">[^\\/\\;\\?\\:\\@\\=\\&\\\"\\<\\>\\#\\{\\}\\|\\\\\\^\\~\\[\\]\\`]*)?");
                        this.mappedGroups.put(groupName, paramName);
                    }
                }
                ++i;
            }
            regex.append(Pattern.quote(this.oasPath.substring(lastMatchEnd, endSlash ? this.oasPath.length() - 1 : this.oasPath.length())));
            if (endSlash) {
                regex.append(QUERY_REGEX_WITH_SLASH);
            } else {
                regex.append(QUERY_REGEX_WITHOUT_SLASH);
            }
            this.resolvedPattern = Pattern.compile(regex.toString());
            return this.resolvedPattern;
        }
        this.resolvedPattern = Pattern.compile(Pattern.quote(this.oasPath));
        return this.resolvedPattern;
    }

    public Pattern getResolvedPattern() {
        return this.resolvedPattern;
    }

    public Map<String, String> getMappedGroups() {
        return this.mappedGroups;
    }
}

