/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.contract.RouterFactory;
import io.vertx.ext.web.api.contract.RouterFactoryException;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3RouterFactoryImpl;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@VertxGen
public interface OpenAPI3RouterFactory
extends RouterFactory<OpenAPI> {
    @Fluent
    public OpenAPI3RouterFactory addSecuritySchemaScopeValidator(String var1, String var2, Handler<RoutingContext> var3);

    @Fluent
    public OpenAPI3RouterFactory addHandlerByOperationId(String var1, Handler<RoutingContext> var2);

    @Fluent
    public OpenAPI3RouterFactory addFailureHandlerByOperationId(String var1, Handler<RoutingContext> var2);

    @Fluent
    public OpenAPI3RouterFactory mountOperationToEventBus(String var1, String var2);

    @Fluent
    public OpenAPI3RouterFactory mountServiceFromTag(String var1, String var2);

    @Fluent
    public OpenAPI3RouterFactory mountServicesFromExtensions();

    @Fluent
    @GenIgnore
    public OpenAPI3RouterFactory mountServiceInterface(Class var1, String var2);

    public static void create(Vertx vertx, String url, Handler<AsyncResult<OpenAPI3RouterFactory>> handler) {
        OpenAPI3RouterFactory.create(vertx, url, Collections.emptyList(), handler);
    }

    public static void create(Vertx vertx, String url, List<JsonObject> auth, Handler<AsyncResult<OpenAPI3RouterFactory>> handler) {
        List authorizationValues = auth.stream().map(obj -> (AuthorizationValue)obj.mapTo(AuthorizationValue.class)).collect(Collectors.toList());
        vertx.executeBlocking(future -> {
            SwaggerParseResult swaggerParseResult = new OpenAPIV3Parser().readLocation(url, authorizationValues, OpenApi3Utils.getParseOptions());
            if (swaggerParseResult.getMessages().isEmpty()) {
                future.complete((Object)new OpenAPI3RouterFactoryImpl(vertx, swaggerParseResult.getOpenAPI()));
            } else if (swaggerParseResult.getMessages().size() == 1 && ((String)swaggerParseResult.getMessages().get(0)).matches("unable to read location `?\\Q" + url + "\\E`?")) {
                future.fail((Throwable)RouterFactoryException.createSpecNotExistsException(url));
            } else {
                future.fail((Throwable)RouterFactoryException.createSpecInvalidException(StringUtils.join((Iterable)swaggerParseResult.getMessages(), (String)", ")));
            }
        }, handler);
    }
}

