/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.api.contract.RouterFactoryOptionsConverter;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class RouterFactoryOptions {
    public static final boolean DEFAULT_MOUNT_VALIDATION_FAILURE_HANDLER = true;
    public static final boolean DEFAULT_MOUNT_NOT_IMPLEMENTED_HANDLER = true;
    public static final boolean DEFAULT_REQUIRE_SECURITY_HANDLERS = true;
    public static final boolean DEFAULT_MOUNT_RESPONSE_CONTENT_TYPE_HANDLER = true;
    public static final String DEFAULT_OPERATION_MODEL_KEY = null;
    private boolean mountValidationFailureHandler;
    private boolean mountNotImplementedHandler;
    private boolean requireSecurityHandlers;
    private boolean mountResponseContentTypeHandler;
    private String operationModelKey;

    public RouterFactoryOptions() {
        this.init();
    }

    public RouterFactoryOptions(JsonObject json) {
        this.init();
        RouterFactoryOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RouterFactoryOptions(RouterFactoryOptions other) {
        this.mountValidationFailureHandler = other.isMountValidationFailureHandler();
        this.mountNotImplementedHandler = other.isMountNotImplementedHandler();
        this.requireSecurityHandlers = other.isRequireSecurityHandlers();
        this.mountResponseContentTypeHandler = other.isMountResponseContentTypeHandler();
        this.operationModelKey = other.getOperationModelKey();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RouterFactoryOptionsConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.mountValidationFailureHandler = true;
        this.mountNotImplementedHandler = true;
        this.requireSecurityHandlers = true;
        this.mountResponseContentTypeHandler = true;
        this.operationModelKey = DEFAULT_OPERATION_MODEL_KEY;
    }

    public boolean isMountValidationFailureHandler() {
        return this.mountValidationFailureHandler;
    }

    @Fluent
    public RouterFactoryOptions setMountValidationFailureHandler(boolean mountGlobalValidationFailureHandler) {
        this.mountValidationFailureHandler = mountGlobalValidationFailureHandler;
        return this;
    }

    public boolean isMountNotImplementedHandler() {
        return this.mountNotImplementedHandler;
    }

    @Fluent
    public RouterFactoryOptions setMountNotImplementedHandler(boolean mountOperationsWithoutHandler) {
        this.mountNotImplementedHandler = mountOperationsWithoutHandler;
        return this;
    }

    public boolean isRequireSecurityHandlers() {
        return this.requireSecurityHandlers;
    }

    @Fluent
    public RouterFactoryOptions setRequireSecurityHandlers(boolean requireSecurityHandlers) {
        this.requireSecurityHandlers = requireSecurityHandlers;
        return this;
    }

    public boolean isMountResponseContentTypeHandler() {
        return this.mountResponseContentTypeHandler;
    }

    @Fluent
    public RouterFactoryOptions setMountResponseContentTypeHandler(boolean mountResponseContentTypeHandler) {
        this.mountResponseContentTypeHandler = mountResponseContentTypeHandler;
        return this;
    }

    public String getOperationModelKey() {
        return this.operationModelKey;
    }

    @Fluent
    public RouterFactoryOptions setOperationModelKey(String operationModelKey) {
        this.operationModelKey = operationModelKey;
        return this;
    }
}

