/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.term;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import java.util.Base64;
import java.util.Map;

public class HttpTermOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, HttpTermOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "authOptions": {
                    break;
                }
                case "charset": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCharset((String)member.getValue());
                    break;
                }
                case "intputrc": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIntputrc((String)member.getValue());
                    break;
                }
                case "shellHtmlResource": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setShellHtmlResource(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "sockJSHandlerOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setSockJSHandlerOptions(new SockJSHandlerOptions((JsonObject)member.getValue()));
                    break;
                }
                case "sockJSPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSockJSPath((String)member.getValue());
                    break;
                }
                case "termJsResource": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTermJsResource(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "vertsShellJsResource": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setVertsShellJsResource(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                }
            }
        }
    }

    public static void toJson(HttpTermOptions obj, JsonObject json) {
        HttpTermOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(HttpTermOptions obj, Map<String, Object> json) {
        if (obj.getCharset() != null) {
            json.put("charset", obj.getCharset());
        }
        if (obj.getIntputrc() != null) {
            json.put("intputrc", obj.getIntputrc());
        }
        if (obj.getShellHtmlResource() != null) {
            json.put("shellHtmlResource", Base64.getEncoder().encodeToString(obj.getShellHtmlResource().getBytes()));
        }
        if (obj.getSockJSPath() != null) {
            json.put("sockJSPath", obj.getSockJSPath());
        }
        if (obj.getTermJsResource() != null) {
            json.put("termJsResource", Base64.getEncoder().encodeToString(obj.getTermJsResource().getBytes()));
        }
        if (obj.getVertsShellJsResource() != null) {
            json.put("vertsShellJsResource", Base64.getEncoder().encodeToString(obj.getVertsShellJsResource().getBytes()));
        }
    }
}

