/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.Vertx;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.SharedData;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;

@Name(value="local-map-put")
@Summary(value="Put key/value in a local map")
public class LocalMapPut
extends AnnotatedCommand {
    private String map;
    private String key;
    private String value;

    @Argument(index=0, argName="map", required=false)
    @Description(value="the local shared map name")
    public void setMap(String map) {
        this.map = map;
    }

    @Argument(index=1, argName="key", required=false)
    @Description(value="the key to put")
    public void setKey(String key) {
        this.key = key;
    }

    @Argument(index=2, argName="value", required=false)
    @Description(value="the value to put")
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void process(CommandProcess process) {
        Vertx vertx = process.vertx();
        SharedData sharedData = vertx.sharedData();
        LocalMap localMap = sharedData.getLocalMap(this.map);
        localMap.put((Object)this.key, (Object)this.value);
        process.end();
    }
}

