/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.command.base.ObjectType;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Name(value="bus-publish")
@Summary(value="Publish a message to the event bus")
public class BusPublish
extends AnnotatedCommand {
    private Pattern HEADER_PATTERN = Pattern.compile("(.*):(.*)");
    protected boolean verbose;
    protected String address;
    protected String body;
    protected DeliveryOptions options = new DeliveryOptions();
    protected ObjectType type = ObjectType.STRING;

    @Argument(index=0, argName="address")
    @Description(value="the bus address destination")
    public void setAddress(String address) {
        this.address = address;
    }

    @Argument(index=1, argName="body", required=false)
    @Description(value="the message body")
    public void setBody(String body) {
        this.body = body;
    }

    @Option(longName="header", acceptMultipleValues=true)
    @Description(value="add an header formatted as header_name:header_value")
    public void setHeaders(List<String> headers) {
        for (String header : headers) {
            Matcher matcher = this.HEADER_PATTERN.matcher(header);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid header value, use: --header foo:bar");
            }
            this.options.addHeader(matcher.group(1), matcher.group(2));
        }
    }

    @Option(longName="verbose", flag=true)
    @Description(value="verbose output")
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Option(longName="type")
    @Description(value="the object type")
    public void setType(ObjectType type) {
        this.type = type;
    }

    protected Object parseBody() {
        return this.body != null ? this.type.parser.apply(this.body) : null;
    }

    @Override
    public void process(CommandProcess process) {
        Object body = this.parseBody();
        process.vertx().eventBus().publish(this.address, body, this.options);
        process.end();
    }
}

