/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.redis.client.RedisOptions;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.net.SocketAddress;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.rxjava.redis.client.Request;
import io.vertx.rxjava.redis.client.Response;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.redis.client.Redis.class)
public class Redis
implements ReadStream<Response> {
    public static final TypeArg<Redis> __TYPE_ARG = new TypeArg(obj -> new Redis((io.vertx.redis.client.Redis)obj), Redis::getDelegate);
    private final io.vertx.redis.client.Redis delegate;
    private Observable<Response> observable;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Redis that = (Redis)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Redis(io.vertx.redis.client.Redis delegate) {
        this.delegate = delegate;
    }

    public io.vertx.redis.client.Redis getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Response> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.redis.client.Response, Response> conv = Response::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public Pipe<Response> pipe() {
        Pipe<Response> ret = Pipe.newInstance(this.delegate.pipe(), Response.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<Response> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<Response> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> pipeToObservable(WriteStream<Response> dst) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxPipeTo(WriteStream<Response> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    public static Redis createClient(io.vertx.rxjava.core.Vertx vertx, SocketAddress address) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (io.vertx.core.net.SocketAddress)address.getDelegate()));
        return ret;
    }

    public static Redis createClient(io.vertx.rxjava.core.Vertx vertx, RedisOptions options) {
        Redis ret = Redis.newInstance(io.vertx.redis.client.Redis.createClient((Vertx)vertx.getDelegate(), (RedisOptions)options));
        return ret;
    }

    public Redis connect(final Handler<AsyncResult<Redis>> handler) {
        this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.redis.client.Redis>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Redis> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Redis.newInstance((io.vertx.redis.client.Redis)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<Redis> connectObservable() {
        ObservableFuture<Redis> handler = RxHelper.observableFuture();
        this.connect(handler.toHandler());
        return handler;
    }

    public Single<Redis> rxConnect() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect((Handler<AsyncResult<Redis>>)fut)));
    }

    @Override
    public Redis exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Redis handler(final Handler<Response> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.redis.client.Response>(){

            public void handle(io.vertx.redis.client.Response event) {
                handler.handle((Object)Response.newInstance(event));
            }
        });
        return this;
    }

    public Redis pause() {
        this.delegate.pause();
        return this;
    }

    public Redis resume() {
        this.delegate.resume();
        return this;
    }

    public Redis fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public Redis endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public Redis send(Request command, final Handler<AsyncResult<Response>> onSend) {
        this.delegate.send(command.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    onSend.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    onSend.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<Response> sendObservable(Request command) {
        ObservableFuture<Response> onSend = RxHelper.observableFuture();
        this.send(command, onSend.toHandler());
        return onSend;
    }

    public Single<Response> rxSend(Request command) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(command, (Handler<AsyncResult<Response>>)fut)));
    }

    public Redis batch(List<Request> commands, final Handler<AsyncResult<List<Response>>> handler) {
        this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<List<io.vertx.redis.client.Response>>>(){

            public void handle(AsyncResult<List<io.vertx.redis.client.Response>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<List<Response>> batchObservable(List<Request> commands) {
        ObservableFuture<List<Response>> handler = RxHelper.observableFuture();
        this.batch(commands, handler.toHandler());
        return handler;
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.batch(commands, (Handler<AsyncResult<List<Response>>>)fut)));
    }

    public SocketAddress socketAddress() {
        SocketAddress ret = SocketAddress.newInstance(this.delegate.socketAddress());
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public static Redis newInstance(io.vertx.redis.client.Redis arg) {
        return arg != null ? new Redis(arg) : null;
    }
}

