/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.pgclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgNotification;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.sqlclient.PreparedQuery;
import io.vertx.rxjava.sqlclient.RowSet;
import io.vertx.rxjava.sqlclient.SqlConnection;
import io.vertx.rxjava.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collectors;
import rx.Single;

@RxGen(value=io.vertx.pgclient.PgConnection.class)
public class PgConnection
extends SqlConnection {
    public static final TypeArg<PgConnection> __TYPE_ARG = new TypeArg(obj -> new PgConnection((io.vertx.pgclient.PgConnection)obj), PgConnection::getDelegate);
    private final io.vertx.pgclient.PgConnection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgConnection that = (PgConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public PgConnection(io.vertx.pgclient.PgConnection delegate) {
        super((io.vertx.sqlclient.SqlConnection)delegate);
        this.delegate = delegate;
    }

    public io.vertx.pgclient.PgConnection getDelegate() {
        return this.delegate;
    }

    public static void connect(io.vertx.rxjava.core.Vertx vertx, PgConnectOptions options, final Handler<AsyncResult<PgConnection>> handler) {
        io.vertx.pgclient.PgConnection.connect((Vertx)vertx.getDelegate(), (PgConnectOptions)options, (Handler)new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>(){

            public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgConnection.newInstance((io.vertx.pgclient.PgConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<PgConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, PgConnectOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> PgConnection.connect(vertx, options, (Handler<AsyncResult<PgConnection>>)fut)));
    }

    public static void connect(io.vertx.rxjava.core.Vertx vertx, final Handler<AsyncResult<PgConnection>> handler) {
        io.vertx.pgclient.PgConnection.connect((Vertx)vertx.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>(){

            public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgConnection.newInstance((io.vertx.pgclient.PgConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<PgConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> PgConnection.connect(vertx, (Handler<AsyncResult<PgConnection>>)fut)));
    }

    public static void connect(io.vertx.rxjava.core.Vertx vertx, String connectionUri, final Handler<AsyncResult<PgConnection>> handler) {
        io.vertx.pgclient.PgConnection.connect((Vertx)vertx.getDelegate(), (String)connectionUri, (Handler)new Handler<AsyncResult<io.vertx.pgclient.PgConnection>>(){

            public void handle(AsyncResult<io.vertx.pgclient.PgConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PgConnection.newInstance((io.vertx.pgclient.PgConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public static Single<PgConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, String connectionUri) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> PgConnection.connect(vertx, connectionUri, (Handler<AsyncResult<PgConnection>>)fut)));
    }

    public PgConnection notificationHandler(Handler<PgNotification> handler) {
        this.delegate.notificationHandler(handler);
        return this;
    }

    public PgConnection cancelRequest(Handler<AsyncResult<Void>> handler) {
        PgConnection ret = PgConnection.newInstance(this.delegate.cancelRequest(handler));
        return ret;
    }

    public int processId() {
        int ret = this.delegate.processId();
        return ret;
    }

    public int secretKey() {
        int ret = this.delegate.secretKey();
        return ret;
    }

    @Override
    public PgConnection prepare(String sql, final Handler<AsyncResult<PreparedQuery>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<PreparedQuery> rxPrepare(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.prepare(sql, (Handler)fut)));
    }

    @Override
    public PgConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public PgConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public PgConnection preparedQuery(String sql, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedQuery(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<RowSet> rxPreparedQuery(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, (Handler)fut)));
    }

    @Override
    public PgConnection query(String sql, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.query(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<RowSet> rxQuery(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.query(sql, (Handler)fut)));
    }

    @Override
    public PgConnection preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<RowSet> rxPreparedQuery(String sql, Tuple arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.preparedQuery(sql, arguments, (Handler)fut)));
    }

    @Override
    public PgConnection preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<RowSet> rxPreparedBatch(String sql, List<Tuple> batch) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.preparedBatch(sql, (List)batch, (Handler)fut)));
    }

    public static PgConnection newInstance(io.vertx.pgclient.PgConnection arg) {
        return arg != null ? new PgConnection(arg) : null;
    }
}

