/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.stomp;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompClientOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.net.NetClient;
import io.vertx.rxjava.ext.stomp.StompClientConnection;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.stomp.StompClient.class)
public class StompClient {
    public static final TypeArg<StompClient> __TYPE_ARG = new TypeArg(obj -> new StompClient((io.vertx.ext.stomp.StompClient)obj), StompClient::getDelegate);
    private final io.vertx.ext.stomp.StompClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompClient that = (StompClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public StompClient(io.vertx.ext.stomp.StompClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.ext.stomp.StompClient getDelegate() {
        return this.delegate;
    }

    public static StompClient create(io.vertx.rxjava.core.Vertx vertx) {
        StompClient ret = StompClient.newInstance(io.vertx.ext.stomp.StompClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static StompClient create(io.vertx.rxjava.core.Vertx vertx, StompClientOptions options) {
        StompClient ret = StompClient.newInstance(io.vertx.ext.stomp.StompClient.create((Vertx)vertx.getDelegate(), (StompClientOptions)options));
        return ret;
    }

    public StompClient connect(int port, String host, final Handler<AsyncResult<StompClientConnection>> resultHandler) {
        this.delegate.connect(port, host, (Handler)new Handler<AsyncResult<io.vertx.ext.stomp.StompClientConnection>>(){

            public void handle(AsyncResult<io.vertx.ext.stomp.StompClientConnection> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<StompClientConnection> connectObservable(int port, String host) {
        ObservableFuture<StompClientConnection> resultHandler = RxHelper.observableFuture();
        this.connect(port, host, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<StompClientConnection> rxConnect(int port, String host) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(port, host, (Handler<AsyncResult<StompClientConnection>>)fut)));
    }

    public StompClient connect(NetClient net, final Handler<AsyncResult<StompClientConnection>> resultHandler) {
        this.delegate.connect(net.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.ext.stomp.StompClientConnection>>(){

            public void handle(AsyncResult<io.vertx.ext.stomp.StompClientConnection> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<StompClientConnection> connectObservable(NetClient net) {
        ObservableFuture<StompClientConnection> resultHandler = RxHelper.observableFuture();
        this.connect(net, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<StompClientConnection> rxConnect(NetClient net) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(net, (Handler<AsyncResult<StompClientConnection>>)fut)));
    }

    public StompClient connect(int port, String host, NetClient net, final Handler<AsyncResult<StompClientConnection>> resultHandler) {
        this.delegate.connect(port, host, net.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.ext.stomp.StompClientConnection>>(){

            public void handle(AsyncResult<io.vertx.ext.stomp.StompClientConnection> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<StompClientConnection> connectObservable(int port, String host, NetClient net) {
        ObservableFuture<StompClientConnection> resultHandler = RxHelper.observableFuture();
        this.connect(port, host, net, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<StompClientConnection> rxConnect(int port, String host, NetClient net) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(port, host, net, (Handler<AsyncResult<StompClientConnection>>)fut)));
    }

    public StompClient connect(final Handler<AsyncResult<StompClientConnection>> resultHandler) {
        this.delegate.connect((Handler)new Handler<AsyncResult<io.vertx.ext.stomp.StompClientConnection>>(){

            public void handle(AsyncResult<io.vertx.ext.stomp.StompClientConnection> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)StompClientConnection.newInstance((io.vertx.ext.stomp.StompClientConnection)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<StompClientConnection> connectObservable() {
        ObservableFuture<StompClientConnection> resultHandler = RxHelper.observableFuture();
        this.connect(resultHandler.toHandler());
        return resultHandler;
    }

    public Single<StompClientConnection> rxConnect() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect((Handler<AsyncResult<StompClientConnection>>)fut)));
    }

    public StompClient receivedFrameHandler(Handler<Frame> handler) {
        this.delegate.receivedFrameHandler(handler);
        return this;
    }

    public StompClient writingFrameHandler(Handler<Frame> handler) {
        this.delegate.writingFrameHandler(handler);
        return this;
    }

    public StompClient errorFrameHandler(Handler<Frame> handler) {
        this.delegate.errorFrameHandler(handler);
        return this;
    }

    public StompClient exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public StompClientOptions options() {
        StompClientOptions ret = this.delegate.options();
        return ret;
    }

    public io.vertx.rxjava.core.Vertx vertx() {
        io.vertx.rxjava.core.Vertx ret = io.vertx.rxjava.core.Vertx.newInstance(this.delegate.vertx());
        return ret;
    }

    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    public static StompClient newInstance(io.vertx.ext.stomp.StompClient arg) {
        return arg != null ? new StompClient(arg) : null;
    }
}

