/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.parsetools;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.ReadStreamSubscriber;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.parsetools.JsonEvent;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.parsetools.JsonParser.class)
public class JsonParser
implements ReadStream<JsonEvent>,
Handler<Buffer> {
    public static final TypeArg<JsonParser> __TYPE_ARG = new TypeArg(obj -> new JsonParser((io.vertx.core.parsetools.JsonParser)obj), JsonParser::getDelegate);
    private final io.vertx.core.parsetools.JsonParser delegate;
    private Observable<JsonEvent> observable;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonParser that = (JsonParser)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public JsonParser(io.vertx.core.parsetools.JsonParser delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.parsetools.JsonParser getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<JsonEvent> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.parsetools.JsonEvent, JsonEvent> conv = JsonEvent::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    public void handle(Buffer event) {
        this.delegate.handle((Object)event.getDelegate());
    }

    @Override
    public Pipe<JsonEvent> pipe() {
        Pipe<JsonEvent> ret = Pipe.newInstance(this.delegate.pipe(), JsonEvent.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<JsonEvent> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<JsonEvent> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> pipeToObservable(WriteStream<JsonEvent> dst) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxPipeTo(WriteStream<JsonEvent> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    public static JsonParser newParser() {
        JsonParser ret = JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser());
        return ret;
    }

    public static JsonParser newParser(ReadStream<Buffer> stream) {
        JsonParser ret = JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser((io.vertx.core.streams.ReadStream)stream.getDelegate()));
        return ret;
    }

    public static JsonParser newParser(Observable<Buffer> stream) {
        JsonParser ret = JsonParser.newInstance(io.vertx.core.parsetools.JsonParser.newParser((io.vertx.core.streams.ReadStream)ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume()));
        return ret;
    }

    public JsonParser write(Buffer buffer) {
        this.delegate.write(buffer.getDelegate());
        return this;
    }

    public void end() {
        this.delegate.end();
    }

    public JsonParser objectEventMode() {
        this.delegate.objectEventMode();
        return this;
    }

    public JsonParser objectValueMode() {
        this.delegate.objectValueMode();
        return this;
    }

    public JsonParser arrayEventMode() {
        this.delegate.arrayEventMode();
        return this;
    }

    public JsonParser arrayValueMode() {
        this.delegate.arrayValueMode();
        return this;
    }

    public JsonParser pause() {
        this.delegate.pause();
        return this;
    }

    public JsonParser resume() {
        this.delegate.resume();
        return this;
    }

    public JsonParser fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public JsonParser endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public JsonParser handler(final Handler<JsonEvent> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.parsetools.JsonEvent>(){

            public void handle(io.vertx.core.parsetools.JsonEvent event) {
                handler.handle((Object)JsonEvent.newInstance(event));
            }
        });
        return this;
    }

    @Override
    public JsonParser exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public static JsonParser newInstance(io.vertx.core.parsetools.JsonParser arg) {
        return arg != null ? new JsonParser(arg) : null;
    }
}

