/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.core.file;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import java.util.function.Function;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements ReadStream<io.vertx.rxjava.core.buffer.Buffer>,
WriteStream<io.vertx.rxjava.core.buffer.Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg(obj -> new AsyncFile((io.vertx.core.file.AsyncFile)obj), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    private Observable<io.vertx.rxjava.core.buffer.Buffer> observable;
    private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.rxjava.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.rxjava.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer data) {
        this.delegate.end((Object)data.getDelegate());
    }

    @Override
    public void end(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end((Object)data.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> endObservable(io.vertx.rxjava.core.buffer.Buffer data) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(data, handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end(data, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.rxjava.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), io.vertx.rxjava.core.buffer.Buffer.__TYPE_ARG);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> pipeToObservable(WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxPipeTo(WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    public AsyncFile handler(final Handler<io.vertx.rxjava.core.buffer.Buffer> handler) {
        this.delegate.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                handler.handle((Object)io.vertx.rxjava.core.buffer.Buffer.newInstance(event));
            }
        });
        return this;
    }

    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    public AsyncFile endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public AsyncFile write(io.vertx.rxjava.core.buffer.Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public AsyncFile write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(io.vertx.rxjava.core.buffer.Buffer data) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(data, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(data, (Handler<AsyncResult<Void>>)fut)));
    }

    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public AsyncFile drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public void end() {
        this.delegate.end();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Deprecated
    public Observable<Void> endObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.end(handler.toHandler());
        return handler;
    }

    public Single<Void> rxEnd() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.end((Handler<AsyncResult<Void>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    @Deprecated
    public Observable<Void> closeObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.close(handler.toHandler());
        return handler;
    }

    public Single<Void> rxClose() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.close((Handler<AsyncResult<Void>>)fut)));
    }

    public AsyncFile write(io.vertx.rxjava.core.buffer.Buffer buffer, long position, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(buffer.getDelegate(), position, handler);
        return this;
    }

    @Deprecated
    public Observable<Void> writeObservable(io.vertx.rxjava.core.buffer.Buffer buffer, long position) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.write(buffer, position, handler.toHandler());
        return handler;
    }

    public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer buffer, long position) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.write(buffer, position, (Handler<AsyncResult<Void>>)fut)));
    }

    public AsyncFile read(io.vertx.rxjava.core.buffer.Buffer buffer, int offset, long position, int length, final Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>> handler) {
        this.delegate.read(buffer.getDelegate(), offset, position, length, (Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)io.vertx.rxjava.core.buffer.Buffer.newInstance((Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<io.vertx.rxjava.core.buffer.Buffer> readObservable(io.vertx.rxjava.core.buffer.Buffer buffer, int offset, long position, int length) {
        ObservableFuture<io.vertx.rxjava.core.buffer.Buffer> handler = RxHelper.observableFuture();
        this.read(buffer, offset, position, length, handler.toHandler());
        return handler;
    }

    public Single<io.vertx.rxjava.core.buffer.Buffer> rxRead(io.vertx.rxjava.core.buffer.Buffer buffer, int offset, long position, int length) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.read(buffer, offset, position, length, (Handler<AsyncResult<io.vertx.rxjava.core.buffer.Buffer>>)fut)));
    }

    public AsyncFile flush() {
        this.delegate.flush();
        return this;
    }

    public AsyncFile flush(Handler<AsyncResult<Void>> handler) {
        this.delegate.flush(handler);
        return this;
    }

    @Deprecated
    public Observable<Void> flushObservable() {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.flush(handler.toHandler());
        return handler;
    }

    public Single<Void> rxFlush() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.flush((Handler<AsyncResult<Void>>)fut)));
    }

    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    public AsyncFile setReadLength(long readLength) {
        this.delegate.setReadLength(readLength);
        return this;
    }

    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

