/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.ColumnDefinition;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.DataFormat;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.codec.MySQLParamDesc;
import io.vertx.mysqlclient.impl.codec.MySQLPreparedStatement;
import io.vertx.mysqlclient.impl.codec.MySQLRowDesc;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import java.nio.charset.StandardCharsets;

class PrepareStatementCodec
extends CommandCodec<PreparedStatement, PrepareStatementCommand> {
    private CommandHandlerState commandHandlerState = CommandHandlerState.INIT;
    private long statementId;
    private int processingIndex;
    private ColumnDefinition[] paramDescs;
    private ColumnDefinition[] columnDescs;

    PrepareStatementCodec(PrepareStatementCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendStatementPrepareCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        switch (this.commandHandlerState) {
            case INIT: {
                short firstByte = payload.getUnsignedByte(payload.readerIndex());
                if (firstByte == 255) {
                    this.handleErrorPacketPayload(payload);
                    break;
                }
                payload.readUnsignedByte();
                long statementId = payload.readUnsignedIntLE();
                int numberOfColumns = payload.readUnsignedShortLE();
                int numberOfParameters = payload.readUnsignedShortLE();
                payload.readByte();
                short numberOfWarnings = payload.readShortLE();
                this.statementId = statementId;
                this.paramDescs = new ColumnDefinition[numberOfParameters];
                this.columnDescs = new ColumnDefinition[numberOfColumns];
                if (numberOfParameters != 0) {
                    this.processingIndex = 0;
                    this.commandHandlerState = CommandHandlerState.HANDLING_PARAM_COLUMN_DEFINITION;
                    break;
                }
                if (numberOfColumns != 0) {
                    this.processingIndex = 0;
                    this.commandHandlerState = CommandHandlerState.HANDLING_COLUMN_COLUMN_DEFINITION;
                    break;
                }
                this.handleReadyForQuery();
                this.resetIntermediaryResult();
                break;
            }
            case HANDLING_PARAM_COLUMN_DEFINITION: {
                this.paramDescs[this.processingIndex++] = this.decodeColumnDefinitionPacketPayload(payload);
                if (this.processingIndex != this.paramDescs.length) break;
                if (this.isDeprecatingEofFlagEnabled()) {
                    this.handleParamDefinitionsDecodingCompleted();
                    break;
                }
                this.commandHandlerState = CommandHandlerState.PARAM_DEFINITIONS_DECODING_COMPLETED;
                break;
            }
            case PARAM_DEFINITIONS_DECODING_COMPLETED: {
                this.skipEofPacketIfNeeded(payload);
                this.handleParamDefinitionsDecodingCompleted();
                break;
            }
            case HANDLING_COLUMN_COLUMN_DEFINITION: {
                this.columnDescs[this.processingIndex++] = this.decodeColumnDefinitionPacketPayload(payload);
                if (this.processingIndex != this.columnDescs.length) break;
                if (this.isDeprecatingEofFlagEnabled()) {
                    this.handleColumnDefinitionsDecodingCompleted();
                    break;
                }
                this.commandHandlerState = CommandHandlerState.COLUMN_DEFINITIONS_DECODING_COMPLETED;
                break;
            }
            case COLUMN_DEFINITIONS_DECODING_COMPLETED: {
                this.handleColumnDefinitionsDecodingCompleted();
            }
        }
    }

    private void sendStatementPrepareCommand() {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(22);
        packet.writeCharSequence((CharSequence)((PrepareStatementCommand)this.cmd).sql(), StandardCharsets.UTF_8);
        int payloadLength = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, payloadLength);
        this.sendPacket(packet, payloadLength);
    }

    private void handleReadyForQuery() {
        this.completionHandler.handle((Object)CommandResponse.success((Object)new MySQLPreparedStatement(((PrepareStatementCommand)this.cmd).sql(), this.statementId, new MySQLParamDesc(this.paramDescs), new MySQLRowDesc(this.columnDescs, DataFormat.BINARY))));
    }

    private void resetIntermediaryResult() {
        this.commandHandlerState = CommandHandlerState.INIT;
        this.statementId = 0L;
        this.processingIndex = 0;
        this.paramDescs = null;
        this.columnDescs = null;
    }

    private void handleParamDefinitionsDecodingCompleted() {
        if (this.columnDescs.length == 0) {
            this.handleReadyForQuery();
            this.resetIntermediaryResult();
        } else {
            this.processingIndex = 0;
            this.commandHandlerState = CommandHandlerState.HANDLING_COLUMN_COLUMN_DEFINITION;
        }
    }

    private void handleColumnDefinitionsDecodingCompleted() {
        this.handleReadyForQuery();
        this.resetIntermediaryResult();
    }

    private static enum CommandHandlerState {
        INIT,
        HANDLING_PARAM_COLUMN_DEFINITION,
        PARAM_DEFINITIONS_DECODING_COMPLETED,
        HANDLING_COLUMN_COLUMN_DEFINITION,
        COLUMN_DEFINITIONS_DECODING_COMPLETED;

    }
}

