/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.sqlclient.impl.SocketConnectionBase;

public class InitiateSslHandler
extends ChannelInboundHandlerAdapter {
    private final SocketConnectionBase conn;
    private final Promise<Void> upgradePromise;

    public InitiateSslHandler(SocketConnectionBase conn, Promise<Void> upgradePromise) {
        this.conn = conn;
        this.upgradePromise = upgradePromise;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        Handler handler = o -> {
            AsyncResult res;
            if (o instanceof AsyncResult && (res = (AsyncResult)o).failed()) {
                return;
            }
            ctx.pipeline().remove((ChannelHandler)this);
            this.upgradePromise.complete();
        };
        this.conn.socket().upgradeToSsl(handler);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ctx.fireExceptionCaught((Throwable)new IllegalStateException("Read illegal data while performing TLS handshake"));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        if (cause instanceof DecoderException) {
            DecoderException err = (DecoderException)cause;
            cause = err.getCause();
        }
        this.upgradePromise.tryFail(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.upgradePromise.tryFail((Throwable)new VertxException("SSL handshake failed", true));
    }
}

