/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.SslMode;
import java.util.Base64;
import java.util.Map;

public class MySQLConnectOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, MySQLConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "charset": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCharset((String)member.getValue());
                    break;
                }
                case "collation": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCollation((String)member.getValue());
                    break;
                }
                case "serverRsaPublicKeyPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServerRsaPublicKeyPath((String)member.getValue());
                    break;
                }
                case "serverRsaPublicKeyValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServerRsaPublicKeyValue(Buffer.buffer((byte[])Base64.getDecoder().decode((String)member.getValue())));
                    break;
                }
                case "sslMode": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSslMode(SslMode.valueOf((String)member.getValue()));
                    break;
                }
                case "useAffectedRows": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseAffectedRows((Boolean)member.getValue());
                }
            }
        }
    }

    public static void toJson(MySQLConnectOptions obj, JsonObject json) {
        MySQLConnectOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(MySQLConnectOptions obj, Map<String, Object> json) {
        if (obj.getCharset() != null) {
            json.put("charset", obj.getCharset());
        }
        if (obj.getCollation() != null) {
            json.put("collation", obj.getCollation());
        }
        if (obj.getServerRsaPublicKeyPath() != null) {
            json.put("serverRsaPublicKeyPath", obj.getServerRsaPublicKeyPath());
        }
        if (obj.getServerRsaPublicKeyValue() != null) {
            json.put("serverRsaPublicKeyValue", Base64.getEncoder().encodeToString(obj.getServerRsaPublicKeyValue().getBytes()));
        }
        if (obj.getSslMode() != null) {
            json.put("sslMode", obj.getSslMode().name());
        }
        json.put("useAffectedRows", obj.isUseAffectedRows());
    }
}

