require 'vertx/async_map'
require 'vertx/lock'
require 'vertx/local_map'
require 'vertx/counter'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.shareddata.SharedData
module Vertx
  #  Shared data allows you to share data safely between different parts of your application in a safe way.
  #  <p>
  #  Shared data provides:
  #  <ul>
  #    <li>synchronous shared maps (local)</li>
  #    <li>asynchronous maps (local or cluster-wide)</li>
  #    <li>asynchronous locks (local or cluster-wide)</li>
  #    <li>asynchronous counters (local or cluster-wide)</li>
  #  </ul>
  #  <p>
  #  <p>
  #    <strong>WARNING</strong>: In clustered mode, asynchronous maps/locks/counters rely on distributed data structures provided by the cluster manager.
  #    Beware that the latency relative to asynchronous maps/locks/counters operations can be much higher in clustered than in local mode.
  #  </p>
  #  Please see the documentation for more information.
  class SharedData
    # @private
    # @param j_del [::Vertx::SharedData] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::SharedData] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SharedData
    end
    def @@j_api_type.wrap(obj)
      SharedData.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreShareddata::SharedData.java_class
    end
    #  Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
    #  put into the map from any node is visible to to any other node.
    # @param [String] name the name of the map
    # @yield the map will be returned asynchronously in this handler
    # @return [void]
    def get_cluster_wide_map(name=nil)
      if name.class == String && block_given?
        return @j_del.java_method(:getClusterWideMap, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(name,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::AsyncMap, nil, nil) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_cluster_wide_map(#{name})"
    end
    #  Get the {::Vertx::AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
    #  and data put into the map from any node is visible to to any other node.
    #  <p>
    #    <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
    #    Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
    #  </p>
    # @param [String] name the name of the map
    # @yield the map will be returned asynchronously in this handler
    # @return [void]
    def get_async_map(name=nil)
      if name.class == String && block_given?
        return @j_del.java_method(:getAsyncMap, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(name,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::AsyncMap, nil, nil) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_async_map(#{name})"
    end
    #  Get the {::Vertx::AsyncMap} with the specified name.
    #  <p>
    #  When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
    #  Only the instance which created the map can put and retrieve data from this map.
    # @param [String] name the name of the map
    # @yield the map will be returned asynchronously in this handler
    # @return [void]
    def get_local_async_map(name=nil)
      if name.class == String && block_given?
        return @j_del.java_method(:getLocalAsyncMap, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(name,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::AsyncMap, nil, nil) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_local_async_map(#{name})"
    end
    #  Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
    #  <p>
    #    In general lock acquision is unordered, so that sequential attempts to acquire a lock,
    #    even from a single thread, can happen in non-sequential order.
    #  </p>
    # @param [String] name the name of the lock
    # @yield the handler
    # @return [void]
    def get_lock(name=nil)
      if name.class == String && block_given?
        return @j_del.java_method(:getLock, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(name,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Lock) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_lock(#{name})"
    end
    #  Like {::Vertx::SharedData#get_lock} but specifying a timeout. If the lock is not obtained within the timeout
    #  a failure will be sent to the handler.
    #  <p>
    #    In general lock acquision is unordered, so that sequential attempts to acquire a lock,
    #    even from a single thread, can happen in non-sequential order.
    #  </p>
    # @param [String] name the name of the lock
    # @param [Fixnum] timeout the timeout in ms
    # @yield the handler
    # @return [void]
    def get_lock_with_timeout(name=nil,timeout=nil)
      if name.class == String && timeout.class == Fixnum && block_given?
        return @j_del.java_method(:getLockWithTimeout, [Java::java.lang.String.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(name,timeout,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Lock) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_lock_with_timeout(#{name},#{timeout})"
    end
    #  Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
    #  <p>
    #    In general lock acquision is unordered, so that sequential attempts to acquire a lock,
    #    even from a single thread, can happen in non-sequential order.
    #  </p>
    # @param [String] name the name of the lock
    # @yield the handler
    # @return [void]
    def get_local_lock(name=nil)
      if name.class == String && block_given?
        return @j_del.java_method(:getLocalLock, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(name,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Lock) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_local_lock(#{name})"
    end
    #  Like {::Vertx::SharedData#get_local_lock} but specifying a timeout. If the lock is not obtained within the timeout
    #  a failure will be sent to the handler.
    #  <p>
    #    In general lock acquision is unordered, so that sequential attempts to acquire a lock,
    #    even from a single thread, can happen in non-sequential order.
    #  </p>
    # @param [String] name the name of the lock
    # @param [Fixnum] timeout the timeout in ms
    # @yield the handler
    # @return [void]
    def get_local_lock_with_timeout(name=nil,timeout=nil)
      if name.class == String && timeout.class == Fixnum && block_given?
        return @j_del.java_method(:getLocalLockWithTimeout, [Java::java.lang.String.java_class,Java::long.java_class,Java::IoVertxCore::Handler.java_class]).call(name,timeout,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Lock) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_local_lock_with_timeout(#{name},#{timeout})"
    end
    #  Get an asynchronous counter. The counter will be passed to the handler.
    # @param [String] name the name of the counter.
    # @yield the handler
    # @return [void]
    def get_counter(name=nil)
      if name.class == String && block_given?
        return @j_del.java_method(:getCounter, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(name,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Counter) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_counter(#{name})"
    end
    #  Get an asynchronous local counter. The counter will be passed to the handler.
    # @param [String] name the name of the counter.
    # @yield the handler
    # @return [void]
    def get_local_counter(name=nil)
      if name.class == String && block_given?
        return @j_del.java_method(:getLocalCounter, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(name,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Counter) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_local_counter(#{name})"
    end
    #  Return a <code>LocalMap</code> with the specific <code>name</code>.
    # @param [String] name the name of the map
    # @return [::Vertx::LocalMap] the msp
    def get_local_map(name=nil)
      if name.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getLocalMap, [Java::java.lang.String.java_class]).call(name),::Vertx::LocalMap, nil, nil)
      end
      raise ArgumentError, "Invalid arguments when calling get_local_map(#{name})"
    end
  end
end
