require 'vertx/measured'
require 'vertx/net_socket'
require 'vertx/socket_address'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.net.NetClient
module Vertx
  #  A TCP client.
  #  <p>
  #  Multiple connections to different servers can be made using the same instance.
  #  <p>
  #  This client supports a configurable number of connection attempts and a configurable
  #  delay between attempts.
  class NetClient
    include ::Vertx::Measured
    # @private
    # @param j_del [::Vertx::NetClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::NetClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == NetClient
    end
    def @@j_api_type.wrap(obj)
      NetClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreNet::NetClient.java_class
    end
    #  Whether the metrics are enabled for this measured object
    # @return [true,false] <code>true</code> if metrics are enabled
    def metrics_enabled?
      if !block_given?
        return @j_del.java_method(:isMetricsEnabled, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling metrics_enabled?()"
    end
    #  Open a connection to a server at the specific <code>port</code> and <code>host</code>.
    #  <p>
    #  <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
    #  {::Vertx::NetSocket} instance is supplied via the <code>connectHandler</code> instance
    # @overload connect(remoteAddress,connectHandler)
    #   @param [::Vertx::SocketAddress] remoteAddress the remote address
    #   @yield 
    # @overload connect(port,host,connectHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @yield 
    # @overload connect(remoteAddress,serverName,connectHandler)
    #   @param [::Vertx::SocketAddress] remoteAddress the remote address
    #   @param [String] serverName the SNI server name
    #   @yield 
    # @overload connect(port,host,serverName,connectHandler)
    #   @param [Fixnum] port the port
    #   @param [String] host the host
    #   @param [String] serverName the SNI server name
    #   @yield 
    # @return [self]
    def connect(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class.method_defined?(:j_del) && block_given? && param_2 == nil && param_3 == nil
        @j_del.java_method(:connect, [Java::IoVertxCoreNet::SocketAddress.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && block_given? && param_3 == nil
        @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) }))
        return self
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && block_given? && param_3 == nil
        @j_del.java_method(:connect, [Java::IoVertxCoreNet::SocketAddress.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,param_2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) }))
        return self
      elsif param_1.class == Fixnum && param_2.class == String && param_3.class == String && block_given?
        @j_del.java_method(:connect, [Java::int.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,param_2,param_3,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::NetSocket) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling connect(#{param_1},#{param_2},#{param_3})"
    end
    #  Close the client.
    #  <p>
    #  Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
    #  complete until some time after the method has returned.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
