require 'vertx/util/utils.rb'
# Generated from io.vertx.core.json.pointer.JsonPointerIterator
module Vertx
  #  The JsonPointerIterator is used by the read/write algorithms of the {::Vertx::JsonPointer} to read/write the querying data structure <br/>
  # 
  #  Every method takes the currentValue as parameter, representing the actual value held by the query algorithm.<br/>
  # 
  #  Implementations of this interface should be stateless, so they can be reused<br/>
  # 
  #  You can implement this interface to query the structure you want using json pointers
  class JsonPointerIterator
    # @private
    # @param j_del [::Vertx::JsonPointerIterator] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::JsonPointerIterator] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JsonPointerIterator
    end
    def @@j_api_type.wrap(obj)
      JsonPointerIterator.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreJsonPointer::JsonPointerIterator.java_class
    end
    # @param [Object] currentValue 
    # @return [true,false] <code>true</code> if the current value is a queryable object
    def object?(currentValue=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && !block_given?
        return @j_del.java_method(:isObject, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(currentValue))
      end
      raise ArgumentError, "Invalid arguments when calling object?(#{currentValue})"
    end
    # @param [Object] currentValue 
    # @return [true,false] <code>true</code> if the current value is a queryable array
    def array?(currentValue=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && !block_given?
        return @j_del.java_method(:isArray, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(currentValue))
      end
      raise ArgumentError, "Invalid arguments when calling array?(#{currentValue})"
    end
    # @param [Object] currentValue 
    # @return [true,false] <code>true</code> if the current value is null/empty
    def null?(currentValue=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && !block_given?
        return @j_del.java_method(:isNull, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(currentValue))
      end
      raise ArgumentError, "Invalid arguments when calling null?(#{currentValue})"
    end
    # @param [Object] currentValue 
    # @param [String] key object key
    # @return [true,false] <code>true</code> if current value is a queryable object that contains the specified key
    def object_contains_key?(currentValue=nil,key=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && key.class == String && !block_given?
        return @j_del.java_method(:objectContainsKey, [Java::java.lang.Object.java_class,Java::java.lang.String.java_class]).call(::Vertx::Util::Utils.to_object(currentValue),key)
      end
      raise ArgumentError, "Invalid arguments when calling object_contains_key?(#{currentValue},#{key})"
    end
    #  Returns the object parameter with specified key.
    # @param [Object] currentValue 
    # @param [String] key object key
    # @param [true,false] createOnMissing If the current value is an object that doesn't contain the key, put an empty object at provided key
    # @return [Object] the requested object parameter, or null if the method was not able to find it
    def get_object_parameter(currentValue=nil,key=nil,createOnMissing=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && key.class == String && (createOnMissing.class == TrueClass || createOnMissing.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getObjectParameter, [Java::java.lang.Object.java_class,Java::java.lang.String.java_class,Java::boolean.java_class]).call(::Vertx::Util::Utils.to_object(currentValue),key,createOnMissing))
      end
      raise ArgumentError, "Invalid arguments when calling get_object_parameter(#{currentValue},#{key},#{createOnMissing})"
    end
    #  Move the iterator the the array element at specified index
    # @param [Object] currentValue 
    # @param [Fixnum] i array index
    # @return [Object] the request array element, or null if the method was not able to find it
    def get_array_element(currentValue=nil,i=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && i.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getArrayElement, [Java::java.lang.Object.java_class,Java::int.java_class]).call(::Vertx::Util::Utils.to_object(currentValue),i))
      end
      raise ArgumentError, "Invalid arguments when calling get_array_element(#{currentValue},#{i})"
    end
    #  Write object parameter at specified key
    # @param [Object] currentValue 
    # @param [String] key 
    # @param [Object] value 
    # @return [true,false] true if the operation is successful
    def write_object_parameter?(currentValue=nil,key=nil,value=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && key.class == String && ::Vertx::Util::unknown_type.accept?(value) && !block_given?
        return @j_del.java_method(:writeObjectParameter, [Java::java.lang.Object.java_class,Java::java.lang.String.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(currentValue),key,::Vertx::Util::Utils.to_object(value))
      end
      raise ArgumentError, "Invalid arguments when calling write_object_parameter?(#{currentValue},#{key},#{value})"
    end
    #  Write array element at specified index
    # @param [Object] currentValue 
    # @param [Fixnum] i 
    # @param [Object] value 
    # @return [true,false] true if the operation is successful
    def write_array_element?(currentValue=nil,i=nil,value=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && i.class == Fixnum && ::Vertx::Util::unknown_type.accept?(value) && !block_given?
        return @j_del.java_method(:writeArrayElement, [Java::java.lang.Object.java_class,Java::int.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(currentValue),i,::Vertx::Util::Utils.to_object(value))
      end
      raise ArgumentError, "Invalid arguments when calling write_array_element?(#{currentValue},#{i},#{value})"
    end
    #  Append array element
    # @param [Object] currentValue 
    # @param [Object] value 
    # @return [true,false] true if the operation is successful
    def append_array_element?(currentValue=nil,value=nil)
      if ::Vertx::Util::unknown_type.accept?(currentValue) && ::Vertx::Util::unknown_type.accept?(value) && !block_given?
        return @j_del.java_method(:appendArrayElement, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(currentValue),::Vertx::Util::Utils.to_object(value))
      end
      raise ArgumentError, "Invalid arguments when calling append_array_element?(#{currentValue},#{value})"
    end
    #  Instance of a JsonPointerIterator to query Vert.x Json structures
    def self.JSON_ITERATOR
      ::Vertx::Util::Utils.safe_create(Java::IoVertxCoreJsonPointer::JsonPointerIterator.JSON_ITERATOR,::Vertx::JsonPointerIterator)
    end
  end
end
