require 'vertx-web-common/template_engine'
require 'vertx/vertx'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.templ.pebble.PebbleTemplateEngine
module VertxWebTemplPebble
  #  A template engine that uses the Pebble library.
  class PebbleTemplateEngine < ::VertxWebCommon::TemplateEngine
    # @private
    # @param j_del [::VertxWebTemplPebble::PebbleTemplateEngine] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebTemplPebble::PebbleTemplateEngine] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PebbleTemplateEngine
    end
    def @@j_api_type.wrap(obj)
      PebbleTemplateEngine.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebTemplPebble::PebbleTemplateEngine.java_class
    end
    #  Render the template. Template engines that support partials/fragments should extract the template base path from
    #  the template filename up to the last file separator.
    # 
    #  Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
    #  be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
    # @param [Hash{String => Object}] context the routing context
    # @param [String] templateFileName the template file name to use
    # @yield the handler that will be called with a result containing the buffer or a failure.
    # @return [void]
    def render(context=nil,templateFileName=nil)
      if context.class == Hash && templateFileName.class == String && block_given?
        return @j_del.java_method(:render, [Java::IoVertxCoreJson::JsonObject.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(context),templateFileName,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::Vertx::Buffer) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling render(#{context},#{templateFileName})"
    end
    #  Returns true if the template template caches template files. If false, then template files are freshly loaded each
    #  time they are used.
    # @return [true,false] True if template files are cached; otherwise, false.
    def caching_enabled?
      if !block_given?
        return @j_del.java_method(:isCachingEnabled, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling caching_enabled?()"
    end
    #  Create a template engine using defaults
    # @param [::Vertx::Vertx] vertx 
    # @return [::VertxWebTemplPebble::PebbleTemplateEngine] the engine
    def self.create(vertx=nil)
      if vertx.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebTemplPebble::PebbleTemplateEngine.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxWebTemplPebble::PebbleTemplateEngine)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx})"
    end
    # @param [String] extension the extension
    # @return [self]
    def set_extension(extension=nil)
      if extension.class == String && !block_given?
        @j_del.java_method(:setExtension, [Java::java.lang.String.java_class]).call(extension)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_extension(#{extension})"
    end
    #  Set the max cache size for the engine
    # @param [Fixnum] maxCacheSize the maxCacheSize
    # @return [self]
    def set_max_cache_size(maxCacheSize=nil)
      if maxCacheSize.class == Fixnum && !block_given?
        @j_del.java_method(:setMaxCacheSize, [Java::int.java_class]).call(maxCacheSize)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_max_cache_size(#{maxCacheSize})"
    end
    #  Default max number of templates to cache
    def self.DEFAULT_MAX_CACHE_SIZE
      Java::IoVertxExtWebTemplPebble::PebbleTemplateEngine.DEFAULT_MAX_CACHE_SIZE
    end
    #  Default template extension
    def self.DEFAULT_TEMPLATE_EXTENSION
      Java::IoVertxExtWebTemplPebble::PebbleTemplateEngine.DEFAULT_TEMPLATE_EXTENSION
    end
  end
end
