require 'vertx-sql-client/sql_connection'
require 'vertx/vertx'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/transaction'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.mysqlclient.MySQLConnection
module VertxMysqlClient
  #  A connection to MySQL server.
  class MySQLConnection < ::VertxSqlClient::SqlConnection
    # @private
    # @param j_del [::VertxMysqlClient::MySQLConnection] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMysqlClient::MySQLConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MySQLConnection
    end
    def @@j_api_type.wrap(obj)
      MySQLConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxMysqlclient::MySQLConnection.java_class
    end
    #  Begin a transaction and returns a  for controlling and tracking
    #  this transaction.
    #  <p/>
    #  When the connection is explicitely closed, any inflight transaction is rollbacked.
    # @return [::VertxSqlClient::Transaction] the transaction instance
    def begin
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:begin, []).call(),::VertxSqlClient::Transaction)
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    # @return [true,false] whether the connection uses SSL
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSSL, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling ssl?()"
    end
    #  Close the current connection after all the pending commands have been processed.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    # @param [String] sql 
    # @param [Array<::VertxSqlClient::Tuple>] batch 
    # @yield 
    # @return [self]
    def prepared_batch(sql=nil,batch=nil)
      if sql.class == String && batch.class == Array && block_given?
        @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,batch.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_batch(#{sql},#{batch})"
    end
    #  Like {::VertxMysqlClient::MySQLConnection#connect} with options build from <code>connectionUri</code>.
    # @overload connect(vertx,connectOptions,handler)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash] connectOptions the options for the connection
    #   @yield the handler called with the connection or the failure
    # @overload connect(vertx,connectionUri,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @yield 
    # @return [void]
    def self.connect(param_1=nil,param_2=nil)
      if param_1.class.method_defined?(:j_del) && param_2.class == Hash && block_given?
        return Java::IoVertxMysqlclient::MySQLConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxMysqlclient::MySQLConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,Java::IoVertxMysqlclient::MySQLConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMysqlClient::MySQLConnection) : nil) }))
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && block_given?
        return Java::IoVertxMysqlclient::MySQLConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,param_2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxMysqlClient::MySQLConnection) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling connect(#{param_1},#{param_2})"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def prepare(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepare(#{sql})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def close_handler
      if block_given?
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close_handler()"
    end
    # @param [String] sql 
    # @param [::VertxSqlClient::Tuple] arguments 
    # @yield 
    # @return [self]
    def prepared_query(sql=nil,arguments=nil)
      if sql.class == String && block_given? && arguments == nil
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      elsif sql.class == String && arguments.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,arguments.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql},#{arguments})"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def query(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  Send a PING command to check if the server is alive.
    # @yield the handler notified when the server responses to client
    # @return [self]
    def ping
      if block_given?
        @j_del.java_method(:ping, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling ping()"
    end
    #  Send a INIT_DB command to change the default schema of the connection.
    # @param [String] schemaName name of the schema to change to
    # @yield the handler notified with the execution result
    # @return [self]
    def specify_schema(schemaName=nil)
      if schemaName.class == String && block_given?
        @j_del.java_method(:specifySchema, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(schemaName,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling specify_schema(#{schemaName})"
    end
    #  Send a STATISTICS command to get a human readable string of the server internal status.
    # @yield the handler notified with the execution result
    # @return [self]
    def get_internal_statistics
      if block_given?
        @j_del.java_method(:getInternalStatistics, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling get_internal_statistics()"
    end
    #  Send a SET_OPTION command to set options for the current connection.
    # @param [:MYSQL_OPTION_MULTI_STATEMENTS_ON,:MYSQL_OPTION_MULTI_STATEMENTS_OFF] option the options to set
    # @yield the handler notified with the execution result
    # @return [self]
    def set_option(option=nil)
      if option.class == Symbol && block_given?
        @j_del.java_method(:setOption, [Java::IoVertxMysqlclient::MySQLSetOption.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxMysqlclient::MySQLSetOption.valueOf(option.to_s),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_option(#{option})"
    end
    #  Send a RESET_CONNECTION command to reset the session state.
    # @yield the handler notified with the execution result
    # @return [self]
    def reset_connection
      if block_given?
        @j_del.java_method(:resetConnection, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling reset_connection()"
    end
    #  Send a DEBUG command to dump debug information to the server's stdout.
    # @yield the handler notified with the execution result
    # @return [self]
    def debug
      if block_given?
        @j_del.java_method(:debug, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling debug()"
    end
    #  Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
    # @param [Hash] options authentication options, only username, password, database, collation and properties will be used.
    # @yield the handler
    # @return [self]
    def change_user(options=nil)
      if options.class == Hash && block_given?
        @j_del.java_method(:changeUser, [Java::IoVertxMysqlclient::MySQLConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(Java::IoVertxMysqlclient::MySQLConnectOptions.new(::Vertx::Util::Utils.to_json_object(options)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling change_user(#{options})"
    end
  end
end
