/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-unit-js/test_completion */
var utils = require('vertx-js/util/utils');
var Completion = require('vertx-unit-js/completion');
var Promise = require('vertx-js/promise');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JTestCompletion = Java.type('io.vertx.ext.unit.TestCompletion');

/**
 This object provides callback-ability for the end of a test suite, the completion <i>succeeds</i>
 when all tests pass otherwise it fails.

 @class
*/
var TestCompletion = function(j_val) {

  var j_testCompletion = j_val;
  var that = this;
  Completion.call(this, j_val, undefined);

  var __super_resolve = this.resolve;
  var __super_handler = this.handler;
  /**
   Completes the future upon completion, otherwise fails it.

   @public
   @param future {Promise} the future to resolve 
   */
  this.resolve =  function(future) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_testCompletion["resolve(io.vertx.core.Promise)"](__args[0]._jdel);
    } else if (typeof __super_resolve != 'undefined') {
      return __super_resolve.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Completion handler to receive a completion signal when this completions completes.

   @public
   @param completionHandler {function} the completion handler 
   */
  this.handler =  function(completionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_testCompletion["handler(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_handler != 'undefined') {
      return __super_handler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_testCompletion;
};

TestCompletion._jclass = utils.getJavaClass("io.vertx.ext.unit.TestCompletion");
TestCompletion._jtype = {accept: function(obj) {
    return TestCompletion._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(TestCompletion.prototype, {});
    TestCompletion.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
TestCompletion._create = function(jdel) {var obj = Object.create(TestCompletion.prototype, {});
  TestCompletion.apply(obj, arguments);
  return obj;
}
module.exports = TestCompletion;