/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-rabbitmq-js/basic_properties */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JBasicProperties = Java.type('io.vertx.rabbitmq.BasicProperties');

/**

 @class
*/
var BasicProperties = function(j_val) {

  var j_basicProperties = j_val;
  var that = this;

  var __super_contentType = this.contentType;
  var __super_contentEncoding = this.contentEncoding;
  var __super_deliveryMode = this.deliveryMode;
  var __super_priority = this.priority;
  var __super_correlationId = this.correlationId;
  var __super_replyTo = this.replyTo;
  var __super_expiration = this.expiration;
  var __super_messageId = this.messageId;
  var __super_timestamp = this.timestamp;
  var __super_type = this.type;
  var __super_userId = this.userId;
  var __super_appId = this.appId;
  var __super_clusterId = this.clusterId;
  /**

   @public

   @return {string} contentType of a message, or <code>null</code> if it has not been set.
   */
  this.contentType =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedcontentType == null) {
        that.cachedcontentType = j_basicProperties["contentType()"]();
      }
      return that.cachedcontentType;
    } else if (typeof __super_contentType != 'undefined') {
      return __super_contentType.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} contentEncoding of a message, or <code>null</code> if it has not been set.
   */
  this.contentEncoding =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedcontentEncoding == null) {
        that.cachedcontentEncoding = j_basicProperties["contentEncoding()"]();
      }
      return that.cachedcontentEncoding;
    } else if (typeof __super_contentEncoding != 'undefined') {
      return __super_contentEncoding.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} deliveryMode of a message, or <code>null</code> if it has not been set.
   */
  this.deliveryMode =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cacheddeliveryMode == null) {
        that.cacheddeliveryMode = j_basicProperties["deliveryMode()"]();
      }
      return that.cacheddeliveryMode;
    } else if (typeof __super_deliveryMode != 'undefined') {
      return __super_deliveryMode.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Retrieve the value in the priority field.

   @public

   @return {number} priority of a message, or <code>null</code> if it has not been set.
   */
  this.priority =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedpriority == null) {
        that.cachedpriority = j_basicProperties["priority()"]();
      }
      return that.cachedpriority;
    } else if (typeof __super_priority != 'undefined') {
      return __super_priority.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} correlationId of a message, or <code>null</code> if it has not been set.
   */
  this.correlationId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedcorrelationId == null) {
        that.cachedcorrelationId = j_basicProperties["correlationId()"]();
      }
      return that.cachedcorrelationId;
    } else if (typeof __super_correlationId != 'undefined') {
      return __super_correlationId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} replyTo address, or <code>null</code> if it has not been set.
   */
  this.replyTo =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedreplyTo == null) {
        that.cachedreplyTo = j_basicProperties["replyTo()"]();
      }
      return that.cachedreplyTo;
    } else if (typeof __super_replyTo != 'undefined') {
      return __super_replyTo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} expiration of a message, or <code>null</code> if it has not been set.
   */
  this.expiration =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedexpiration == null) {
        that.cachedexpiration = j_basicProperties["expiration()"]();
      }
      return that.cachedexpiration;
    } else if (typeof __super_expiration != 'undefined') {
      return __super_expiration.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} messageId, or <code>null</code> if it has not been set.
   */
  this.messageId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedmessageId == null) {
        that.cachedmessageId = j_basicProperties["messageId()"]();
      }
      return that.cachedmessageId;
    } else if (typeof __super_messageId != 'undefined') {
      return __super_messageId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} timestamp of a message, or <code>null</code> if it has not been set.
   */
  this.timestamp =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedtimestamp == null) {
        that.cachedtimestamp = utils.convReturnLong(j_basicProperties["timestamp()"]());
      }
      return that.cachedtimestamp;
    } else if (typeof __super_timestamp != 'undefined') {
      return __super_timestamp.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} type of a message, or <code>null</code> if it has not been set.
   */
  this.type =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedtype == null) {
        that.cachedtype = j_basicProperties["type()"]();
      }
      return that.cachedtype;
    } else if (typeof __super_type != 'undefined') {
      return __super_type.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} userId, or <code>null</code> if it has not been set.
   */
  this.userId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cacheduserId == null) {
        that.cacheduserId = j_basicProperties["userId()"]();
      }
      return that.cacheduserId;
    } else if (typeof __super_userId != 'undefined') {
      return __super_userId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} appId, or <code>null</code> if it has not been set.
   */
  this.appId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedappId == null) {
        that.cachedappId = j_basicProperties["appId()"]();
      }
      return that.cachedappId;
    } else if (typeof __super_appId != 'undefined') {
      return __super_appId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {string} clusterId, or <code>null</code> if it has not been set.
   */
  this.clusterId =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      if (that.cachedclusterId == null) {
        that.cachedclusterId = j_basicProperties["clusterId()"]();
      }
      return that.cachedclusterId;
    } else if (typeof __super_clusterId != 'undefined') {
      return __super_clusterId.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_basicProperties;
};

BasicProperties._jclass = utils.getJavaClass("io.vertx.rabbitmq.BasicProperties");
BasicProperties._jtype = {accept: function(obj) {
    return BasicProperties._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(BasicProperties.prototype, {});
    BasicProperties.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
BasicProperties._create = function(jdel) {var obj = Object.create(BasicProperties.prototype, {});
  BasicProperties.apply(obj, arguments);
  return obj;
}
module.exports = BasicProperties;