/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-mysql-postgresql-js/postgre_sql_client */
var utils = require('vertx-js/util/utils');
var AsyncSQLClient = require('vertx-mysql-postgresql-js/async_sql_client');
var Vertx = require('vertx-js/vertx');
var SQLClient = require('vertx-sql-js/sql_client');
var SQLOperations = require('vertx-sql-js/sql_operations');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JPostgreSQLClient = Java.type('io.vertx.ext.asyncsql.PostgreSQLClient');

/**
 Represents an PostgreSQL client

 @class
*/
var PostgreSQLClient = function(j_val) {

  var j_postgreSQLClient = j_val;
  var that = this;
  AsyncSQLClient.call(this, j_val);

  var __super_querySingle = this.querySingle;
  var __super_querySingleWithParams = this.querySingleWithParams;
  var __super_createNonShared = this.createNonShared;
  var __super_createShared = this.createShared;
  var __super_createShared = this.createShared;
  /**
   Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   getting a connection from the pool (this object) and return it back after the execution. Only the first result
   from the result set is returned.

   @public
   @param sql {string} the statement to execute 
   @param handler {function} the result handler 
   @return {SQLOperations} self
   */
  this.querySingle =  function(sql, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_postgreSQLClient["querySingle(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_querySingle != 'undefined') {
      return __super_querySingle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   Only the first result from the result set is returned.

   @public
   @param sql {string} the statement to execute 
   @param arguments {Array} the arguments 
   @param handler {function} the result handler 
   @return {SQLOperations} self
   */
  this.querySingleWithParams =  function(sql, arguments, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_postgreSQLClient["querySingleWithParams(java.lang.String,io.vertx.core.json.JsonArray,io.vertx.core.Handler)"](__args[0], utils.convParamJsonArray(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnJson(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_querySingleWithParams != 'undefined') {
      return __super_querySingleWithParams.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_postgreSQLClient;
};

PostgreSQLClient._jclass = utils.getJavaClass("io.vertx.ext.asyncsql.PostgreSQLClient");
PostgreSQLClient._jtype = {accept: function(obj) {
    return PostgreSQLClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PostgreSQLClient.prototype, {});
    PostgreSQLClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PostgreSQLClient._create = function(jdel) {var obj = Object.create(PostgreSQLClient.prototype, {});
  PostgreSQLClient.apply(obj, arguments);
  return obj;
}
/**
 Create a PostgreSQL client which maintains its own pool.

 @memberof module:vertx-mysql-postgresql-js/postgre_sql_client
 @param vertx {Vertx} the Vert.x instance 
 @param config {Object} the configuration 
 @return {AsyncSQLClient} the client
 */
PostgreSQLClient.createNonShared =  function(vertx, config) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(AsyncSQLClient, JPostgreSQLClient["createNonShared(io.vertx.core.Vertx,io.vertx.core.json.JsonObject)"](__args[0]._jdel, utils.convParamJsonObject(__args[1]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Like {@link PostgreSQLClient#createShared} but with the default pool name

 @memberof module:vertx-mysql-postgresql-js/postgre_sql_client
 @param vertx {Vertx} the Vert.x instance 
 @param config {Object} the configuration 
 @return {AsyncSQLClient} the client
 */
PostgreSQLClient.createShared =  function() {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'string') {
    return utils.convReturnVertxGen(AsyncSQLClient, JPostgreSQLClient["createShared(io.vertx.core.Vertx,io.vertx.core.json.JsonObject,java.lang.String)"](__args[0]._jdel, utils.convParamJsonObject(__args[1]), __args[2])) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(AsyncSQLClient, JPostgreSQLClient["createShared(io.vertx.core.Vertx,io.vertx.core.json.JsonObject)"](__args[0]._jdel, utils.convParamJsonObject(__args[1]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

PostgreSQLClient.DEFAULT_DS_NAME = JPostgreSQLClient.DEFAULT_DS_NAME;
PostgreSQLClient.DEFAULT_HOST = JPostgreSQLClient.DEFAULT_HOST;
PostgreSQLClient.DEFAULT_PORT = JPostgreSQLClient.DEFAULT_PORT;
PostgreSQLClient.DEFAULT_DATABASE = JPostgreSQLClient.DEFAULT_DATABASE;
PostgreSQLClient.DEFAULT_USER = JPostgreSQLClient.DEFAULT_USER;
PostgreSQLClient.DEFAULT_PASSWORD = JPostgreSQLClient.DEFAULT_PASSWORD;
PostgreSQLClient.DEFAULT_CHARSET = JPostgreSQLClient.DEFAULT_CHARSET;
PostgreSQLClient.DEFAULT_CONNECT_TIMEOUT = JPostgreSQLClient.DEFAULT_CONNECT_TIMEOUT;
PostgreSQLClient.DEFAULT_TEST_TIMEOUT = JPostgreSQLClient.DEFAULT_TEST_TIMEOUT;
module.exports = PostgreSQLClient;