/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-consul-js/consul_service */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var ConsulClient = require('vertx-consul-js/consul_client');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JConsulService = Java.type('io.vertx.ext.consul.ConsulService');
var ServiceQueryOptions = Java.type('io.vertx.ext.consul.ServiceQueryOptions');
var PreparedQueryDefinition = Java.type('io.vertx.ext.consul.PreparedQueryDefinition');
var Event = Java.type('io.vertx.ext.consul.Event');
var EventListOptions = Java.type('io.vertx.ext.consul.EventListOptions');
var SessionList = Java.type('io.vertx.ext.consul.SessionList');
var MaintenanceOptions = Java.type('io.vertx.ext.consul.MaintenanceOptions');
var Check = Java.type('io.vertx.ext.consul.Check');
var Service = Java.type('io.vertx.ext.consul.Service');
var CheckOptions = Java.type('io.vertx.ext.consul.CheckOptions');
var ServiceEntryList = Java.type('io.vertx.ext.consul.ServiceEntryList');
var NodeQueryOptions = Java.type('io.vertx.ext.consul.NodeQueryOptions');
var KeyValue = Java.type('io.vertx.ext.consul.KeyValue');
var ServiceOptions = Java.type('io.vertx.ext.consul.ServiceOptions');
var TxnRequest = Java.type('io.vertx.ext.consul.TxnRequest');
var ServiceList = Java.type('io.vertx.ext.consul.ServiceList');
var BlockingQueryOptions = Java.type('io.vertx.ext.consul.BlockingQueryOptions');
var PreparedQueryExecuteOptions = Java.type('io.vertx.ext.consul.PreparedQueryExecuteOptions');
var NodeList = Java.type('io.vertx.ext.consul.NodeList');
var CheckQueryOptions = Java.type('io.vertx.ext.consul.CheckQueryOptions');
var TxnResponse = Java.type('io.vertx.ext.consul.TxnResponse');
var EventList = Java.type('io.vertx.ext.consul.EventList');
var PreparedQueryExecuteResponse = Java.type('io.vertx.ext.consul.PreparedQueryExecuteResponse');
var CoordinateList = Java.type('io.vertx.ext.consul.CoordinateList');
var KeyValueOptions = Java.type('io.vertx.ext.consul.KeyValueOptions');
var AclToken = Java.type('io.vertx.ext.consul.AclToken');
var SessionOptions = Java.type('io.vertx.ext.consul.SessionOptions');
var KeyValueList = Java.type('io.vertx.ext.consul.KeyValueList');
var CheckList = Java.type('io.vertx.ext.consul.CheckList');
var DcCoordinates = Java.type('io.vertx.ext.consul.DcCoordinates');
var Session = Java.type('io.vertx.ext.consul.Session');
var EventOptions = Java.type('io.vertx.ext.consul.EventOptions');

/**
 @class
*/
var ConsulService = function(j_val) {

  var j_consulService = j_val;
  var that = this;
  ConsulClient.call(this, j_val);

  var __super_createEventBusProxy = this.createEventBusProxy;
  var __super_agentInfo = this.agentInfo;
  var __super_coordinateNodes = this.coordinateNodes;
  var __super_coordinateNodesWithOptions = this.coordinateNodesWithOptions;
  var __super_coordinateDatacenters = this.coordinateDatacenters;
  var __super_getKeys = this.getKeys;
  var __super_getKeysWithOptions = this.getKeysWithOptions;
  var __super_getValue = this.getValue;
  var __super_getValueWithOptions = this.getValueWithOptions;
  var __super_deleteValue = this.deleteValue;
  var __super_getValues = this.getValues;
  var __super_getValuesWithOptions = this.getValuesWithOptions;
  var __super_deleteValues = this.deleteValues;
  var __super_putValue = this.putValue;
  var __super_putValueWithOptions = this.putValueWithOptions;
  var __super_transaction = this.transaction;
  var __super_createAclToken = this.createAclToken;
  var __super_updateAclToken = this.updateAclToken;
  var __super_cloneAclToken = this.cloneAclToken;
  var __super_listAclTokens = this.listAclTokens;
  var __super_infoAclToken = this.infoAclToken;
  var __super_destroyAclToken = this.destroyAclToken;
  var __super_fireEvent = this.fireEvent;
  var __super_fireEventWithOptions = this.fireEventWithOptions;
  var __super_listEvents = this.listEvents;
  var __super_listEventsWithOptions = this.listEventsWithOptions;
  var __super_registerService = this.registerService;
  var __super_maintenanceService = this.maintenanceService;
  var __super_deregisterService = this.deregisterService;
  var __super_healthChecks = this.healthChecks;
  var __super_healthChecksWithOptions = this.healthChecksWithOptions;
  var __super_healthState = this.healthState;
  var __super_healthStateWithOptions = this.healthStateWithOptions;
  var __super_healthServiceNodes = this.healthServiceNodes;
  var __super_healthServiceNodesWithOptions = this.healthServiceNodesWithOptions;
  var __super_catalogServiceNodes = this.catalogServiceNodes;
  var __super_catalogServiceNodesWithOptions = this.catalogServiceNodesWithOptions;
  var __super_catalogDatacenters = this.catalogDatacenters;
  var __super_catalogNodes = this.catalogNodes;
  var __super_catalogNodesWithOptions = this.catalogNodesWithOptions;
  var __super_catalogServices = this.catalogServices;
  var __super_catalogServicesWithOptions = this.catalogServicesWithOptions;
  var __super_localServices = this.localServices;
  var __super_catalogNodeServices = this.catalogNodeServices;
  var __super_catalogNodeServicesWithOptions = this.catalogNodeServicesWithOptions;
  var __super_localChecks = this.localChecks;
  var __super_registerCheck = this.registerCheck;
  var __super_deregisterCheck = this.deregisterCheck;
  var __super_passCheck = this.passCheck;
  var __super_passCheckWithNote = this.passCheckWithNote;
  var __super_warnCheck = this.warnCheck;
  var __super_warnCheckWithNote = this.warnCheckWithNote;
  var __super_failCheck = this.failCheck;
  var __super_failCheckWithNote = this.failCheckWithNote;
  var __super_updateCheck = this.updateCheck;
  var __super_updateCheckWithNote = this.updateCheckWithNote;
  var __super_leaderStatus = this.leaderStatus;
  var __super_peersStatus = this.peersStatus;
  var __super_createSession = this.createSession;
  var __super_createSessionWithOptions = this.createSessionWithOptions;
  var __super_infoSession = this.infoSession;
  var __super_infoSessionWithOptions = this.infoSessionWithOptions;
  var __super_renewSession = this.renewSession;
  var __super_listSessions = this.listSessions;
  var __super_listSessionsWithOptions = this.listSessionsWithOptions;
  var __super_listNodeSessions = this.listNodeSessions;
  var __super_listNodeSessionsWithOptions = this.listNodeSessionsWithOptions;
  var __super_destroySession = this.destroySession;
  var __super_createPreparedQuery = this.createPreparedQuery;
  var __super_getPreparedQuery = this.getPreparedQuery;
  var __super_getAllPreparedQueries = this.getAllPreparedQueries;
  var __super_updatePreparedQuery = this.updatePreparedQuery;
  var __super_deletePreparedQuery = this.deletePreparedQuery;
  var __super_executePreparedQuery = this.executePreparedQuery;
  var __super_executePreparedQueryWithOptions = this.executePreparedQueryWithOptions;
  var __super_close = this.close;
  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.agentInfo =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["agentInfo(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_agentInfo != 'undefined') {
      return __super_agentInfo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.coordinateNodes =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["coordinateNodes(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_coordinateNodes != 'undefined') {
      return __super_coordinateNodes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.coordinateNodesWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["coordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_coordinateNodesWithOptions != 'undefined') {
      return __super_coordinateNodesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.coordinateDatacenters =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["coordinateDatacenters(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_coordinateDatacenters != 'undefined') {
      return __super_coordinateDatacenters.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param keyPrefix {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.getKeys =  function(keyPrefix, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["getKeys(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getKeys != 'undefined') {
      return __super_getKeys.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param keyPrefix {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.getKeysWithOptions =  function(keyPrefix, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["getKeysWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](ar.result(), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getKeysWithOptions != 'undefined') {
      return __super_getKeysWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param key {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.getValue =  function(key, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["getValue(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getValue != 'undefined') {
      return __super_getValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param key {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.getValueWithOptions =  function(key, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["getValueWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getValueWithOptions != 'undefined') {
      return __super_getValueWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param key {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.deleteValue =  function(key, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["deleteValue(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deleteValue != 'undefined') {
      return __super_deleteValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param keyPrefix {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.getValues =  function(keyPrefix, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["getValues(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getValues != 'undefined') {
      return __super_getValues.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param keyPrefix {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.getValuesWithOptions =  function(keyPrefix, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["getValuesWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getValuesWithOptions != 'undefined') {
      return __super_getValuesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param keyPrefix {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.deleteValues =  function(keyPrefix, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["deleteValues(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deleteValues != 'undefined') {
      return __super_deleteValues.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param key {string} 
   @param value {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.putValue =  function(key, value, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulService["putValue(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](ar.result(), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_putValue != 'undefined') {
      return __super_putValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param key {string} 
   @param value {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.putValueWithOptions =  function(key, value, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_consulService["putValueWithOptions(java.lang.String,java.lang.String,io.vertx.ext.consul.KeyValueOptions,io.vertx.core.Handler)"](__args[0], __args[1], __args[2]  != null ? new KeyValueOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[3](ar.result(), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_putValueWithOptions != 'undefined') {
      return __super_putValueWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param request {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.transaction =  function(request, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["transaction(io.vertx.ext.consul.TxnRequest,io.vertx.core.Handler)"](__args[0]  != null ? new TxnRequest(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_transaction != 'undefined') {
      return __super_transaction.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param token {Object} 
   @param idHandler {function} 
   @return {ConsulService}
   */
  this.createAclToken =  function(token, idHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["createAclToken(io.vertx.ext.consul.AclToken,io.vertx.core.Handler)"](__args[0]  != null ? new AclToken(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createAclToken != 'undefined') {
      return __super_createAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param token {Object} 
   @param idHandler {function} 
   @return {ConsulService}
   */
  this.updateAclToken =  function(token, idHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["updateAclToken(io.vertx.ext.consul.AclToken,io.vertx.core.Handler)"](__args[0]  != null ? new AclToken(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateAclToken != 'undefined') {
      return __super_updateAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param idHandler {function} 
   @return {ConsulService}
   */
  this.cloneAclToken =  function(id, idHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["cloneAclToken(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_cloneAclToken != 'undefined') {
      return __super_cloneAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.listAclTokens =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["listAclTokens(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listAclTokens != 'undefined') {
      return __super_listAclTokens.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param tokenHandler {function} 
   @return {ConsulService}
   */
  this.infoAclToken =  function(id, tokenHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["infoAclToken(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_infoAclToken != 'undefined') {
      return __super_infoAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.destroyAclToken =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["destroyAclToken(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_destroyAclToken != 'undefined') {
      return __super_destroyAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param name {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.fireEvent =  function(name, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["fireEvent(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_fireEvent != 'undefined') {
      return __super_fireEvent.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param name {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.fireEventWithOptions =  function(name, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["fireEventWithOptions(java.lang.String,io.vertx.ext.consul.EventOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new EventOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_fireEventWithOptions != 'undefined') {
      return __super_fireEventWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.listEvents =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["listEvents(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listEvents != 'undefined') {
      return __super_listEvents.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.listEventsWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["listEventsWithOptions(io.vertx.ext.consul.EventListOptions,io.vertx.core.Handler)"](__args[0]  != null ? new EventListOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listEventsWithOptions != 'undefined') {
      return __super_listEventsWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param serviceOptions {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.registerService =  function(serviceOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["registerService(io.vertx.ext.consul.ServiceOptions,io.vertx.core.Handler)"](__args[0]  != null ? new ServiceOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_registerService != 'undefined') {
      return __super_registerService.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param maintenanceOptions {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.maintenanceService =  function(maintenanceOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["maintenanceService(io.vertx.ext.consul.MaintenanceOptions,io.vertx.core.Handler)"](__args[0]  != null ? new MaintenanceOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_maintenanceService != 'undefined') {
      return __super_maintenanceService.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.deregisterService =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["deregisterService(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deregisterService != 'undefined') {
      return __super_deregisterService.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param service {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.healthChecks =  function(service, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["healthChecks(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthChecks != 'undefined') {
      return __super_healthChecks.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param service {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.healthChecksWithOptions =  function(service, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["healthChecksWithOptions(java.lang.String,io.vertx.ext.consul.CheckQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new CheckQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthChecksWithOptions != 'undefined') {
      return __super_healthChecksWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param healthState {Object} 
   @param handler {function} 
   @return {ConsulService}
   */
  this.healthState =  function(healthState, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["healthState(io.vertx.ext.consul.HealthState,io.vertx.core.Handler)"](io.vertx.ext.consul.HealthState.valueOf(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthState != 'undefined') {
      return __super_healthState.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param healthState {Object} 
   @param checkQueryOptions {Object} 
   @param handler {function} 
   @return {ConsulService}
   */
  this.healthStateWithOptions =  function(healthState, checkQueryOptions, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["healthStateWithOptions(io.vertx.ext.consul.HealthState,io.vertx.ext.consul.CheckQueryOptions,io.vertx.core.Handler)"](io.vertx.ext.consul.HealthState.valueOf(__args[0]), __args[1]  != null ? new CheckQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthStateWithOptions != 'undefined') {
      return __super_healthStateWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param service {string} 
   @param passing {boolean} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.healthServiceNodes =  function(service, passing, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] ==='boolean' && typeof __args[2] === 'function') {
      j_consulService["healthServiceNodes(java.lang.String,boolean,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthServiceNodes != 'undefined') {
      return __super_healthServiceNodes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param service {string} 
   @param passing {boolean} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.healthServiceNodesWithOptions =  function(service, passing, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] ==='boolean' && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_consulService["healthServiceNodesWithOptions(java.lang.String,boolean,io.vertx.ext.consul.ServiceQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1], __args[2]  != null ? new ServiceQueryOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthServiceNodesWithOptions != 'undefined') {
      return __super_healthServiceNodesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param service {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogServiceNodes =  function(service, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["catalogServiceNodes(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogServiceNodes != 'undefined') {
      return __super_catalogServiceNodes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param service {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogServiceNodesWithOptions =  function(service, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["catalogServiceNodesWithOptions(java.lang.String,io.vertx.ext.consul.ServiceQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new ServiceQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogServiceNodesWithOptions != 'undefined') {
      return __super_catalogServiceNodesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogDatacenters =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["catalogDatacenters(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogDatacenters != 'undefined') {
      return __super_catalogDatacenters.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogNodes =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["catalogNodes(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogNodes != 'undefined') {
      return __super_catalogNodes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogNodesWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["catalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions,io.vertx.core.Handler)"](__args[0]  != null ? new NodeQueryOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogNodesWithOptions != 'undefined') {
      return __super_catalogNodesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogServices =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["catalogServices(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogServices != 'undefined') {
      return __super_catalogServices.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogServicesWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["catalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogServicesWithOptions != 'undefined') {
      return __super_catalogServicesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.localServices =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["localServices(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_localServices != 'undefined') {
      return __super_localServices.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param node {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogNodeServices =  function(node, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["catalogNodeServices(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogNodeServices != 'undefined') {
      return __super_catalogNodeServices.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param node {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.catalogNodeServicesWithOptions =  function(node, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["catalogNodeServicesWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogNodeServicesWithOptions != 'undefined') {
      return __super_catalogNodeServicesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.localChecks =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["localChecks(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_localChecks != 'undefined') {
      return __super_localChecks.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkOptions {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.registerCheck =  function(checkOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["registerCheck(io.vertx.ext.consul.CheckOptions,io.vertx.core.Handler)"](__args[0]  != null ? new CheckOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_registerCheck != 'undefined') {
      return __super_registerCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.deregisterCheck =  function(checkId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["deregisterCheck(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deregisterCheck != 'undefined') {
      return __super_deregisterCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.passCheck =  function(checkId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["passCheck(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_passCheck != 'undefined') {
      return __super_passCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param note {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.passCheckWithNote =  function(checkId, note, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulService["passCheckWithNote(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_passCheckWithNote != 'undefined') {
      return __super_passCheckWithNote.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.warnCheck =  function(checkId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["warnCheck(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_warnCheck != 'undefined') {
      return __super_warnCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param note {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.warnCheckWithNote =  function(checkId, note, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulService["warnCheckWithNote(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_warnCheckWithNote != 'undefined') {
      return __super_warnCheckWithNote.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.failCheck =  function(checkId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["failCheck(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_failCheck != 'undefined') {
      return __super_failCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param note {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.failCheckWithNote =  function(checkId, note, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulService["failCheckWithNote(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_failCheckWithNote != 'undefined') {
      return __super_failCheckWithNote.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param status {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.updateCheck =  function(checkId, status, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulService["updateCheck(java.lang.String,io.vertx.ext.consul.CheckStatus,io.vertx.core.Handler)"](__args[0], io.vertx.ext.consul.CheckStatus.valueOf(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateCheck != 'undefined') {
      return __super_updateCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param checkId {string} 
   @param status {Object} 
   @param note {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.updateCheckWithNote =  function(checkId, status, note, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_consulService["updateCheckWithNote(java.lang.String,io.vertx.ext.consul.CheckStatus,java.lang.String,io.vertx.core.Handler)"](__args[0], io.vertx.ext.consul.CheckStatus.valueOf(__args[1]), __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateCheckWithNote != 'undefined') {
      return __super_updateCheckWithNote.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.leaderStatus =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["leaderStatus(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_leaderStatus != 'undefined') {
      return __super_leaderStatus.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.peersStatus =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["peersStatus(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_peersStatus != 'undefined') {
      return __super_peersStatus.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param idHandler {function} 
   @return {ConsulService}
   */
  this.createSession =  function(idHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["createSession(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createSession != 'undefined') {
      return __super_createSession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param options {Object} 
   @param idHandler {function} 
   @return {ConsulService}
   */
  this.createSessionWithOptions =  function(options, idHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["createSessionWithOptions(io.vertx.ext.consul.SessionOptions,io.vertx.core.Handler)"](__args[0]  != null ? new SessionOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createSessionWithOptions != 'undefined') {
      return __super_createSessionWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.infoSession =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["infoSession(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_infoSession != 'undefined') {
      return __super_infoSession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.infoSessionWithOptions =  function(id, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["infoSessionWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_infoSessionWithOptions != 'undefined') {
      return __super_infoSessionWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.renewSession =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["renewSession(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_renewSession != 'undefined') {
      return __super_renewSession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.listSessions =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["listSessions(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listSessions != 'undefined') {
      return __super_listSessions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.listSessionsWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["listSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listSessionsWithOptions != 'undefined') {
      return __super_listSessionsWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param nodeId {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.listNodeSessions =  function(nodeId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["listNodeSessions(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listNodeSessions != 'undefined') {
      return __super_listNodeSessions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param nodeId {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.listNodeSessionsWithOptions =  function(nodeId, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["listNodeSessionsWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listNodeSessionsWithOptions != 'undefined') {
      return __super_listNodeSessionsWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.destroySession =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["destroySession(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_destroySession != 'undefined') {
      return __super_destroySession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param definition {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.createPreparedQuery =  function(definition, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["createPreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition,io.vertx.core.Handler)"](__args[0]  != null ? new PreparedQueryDefinition(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createPreparedQuery != 'undefined') {
      return __super_createPreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.getPreparedQuery =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["getPreparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getPreparedQuery != 'undefined') {
      return __super_getPreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.getAllPreparedQueries =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulService["getAllPreparedQueries(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getAllPreparedQueries != 'undefined') {
      return __super_getAllPreparedQueries.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param definition {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.updatePreparedQuery =  function(definition, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulService["updatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition,io.vertx.core.Handler)"](__args[0]  != null ? new PreparedQueryDefinition(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updatePreparedQuery != 'undefined') {
      return __super_updatePreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param id {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.deletePreparedQuery =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["deletePreparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deletePreparedQuery != 'undefined') {
      return __super_deletePreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param query {string} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.executePreparedQuery =  function(query, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulService["executePreparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_executePreparedQuery != 'undefined') {
      return __super_executePreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param query {string} 
   @param options {Object} 
   @param resultHandler {function} 
   @return {ConsulService}
   */
  this.executePreparedQueryWithOptions =  function(query, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulService["executePreparedQueryWithOptions(java.lang.String,io.vertx.ext.consul.PreparedQueryExecuteOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new PreparedQueryExecuteOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_executePreparedQueryWithOptions != 'undefined') {
      return __super_executePreparedQueryWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_consulService["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_consulService;
};

ConsulService._jclass = utils.getJavaClass("io.vertx.ext.consul.ConsulService");
ConsulService._jtype = {accept: function(obj) {
    return ConsulService._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ConsulService.prototype, {});
    ConsulService.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ConsulService._create = function(jdel) {var obj = Object.create(ConsulService.prototype, {});
  ConsulService.apply(obj, arguments);
  return obj;
}
/**
 Create a proxy to a service that is deployed somewhere on the event bus

 @memberof module:vertx-consul-js/consul_service
 @param vertx {Vertx} the Vert.x instance 
 @param address {string} the address the service is listening on on the event bus 
 @return {ConsulService} the service
 */
ConsulService.createEventBusProxy =  function(vertx, address) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(ConsulService, JConsulService["createEventBusProxy(io.vertx.core.Vertx,java.lang.String)"](__args[0]._jdel, __args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = ConsulService;