/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.util.Arrays;
import java.util.Objects;

public class ClusterSerializationUtils {
    public static <T> T marshal(T obj) {
        if (obj instanceof ClusterSerializable) {
            return (T)ClusterSerializationUtils.marshal0((ClusterSerializable)obj);
        }
        return obj;
    }

    public static <T> T unmarshal(T obj) {
        if (obj instanceof ClusterSerializableValue) {
            return (T)ClusterSerializationUtils.unmarshal0((ClusterSerializableValue)obj);
        }
        return obj;
    }

    private static ClusterSerializableValue marshal0(ClusterSerializable obj) {
        Buffer buffer = Buffer.buffer();
        obj.writeToBuffer(buffer);
        return new ClusterSerializableValue(obj.getClass().getName(), buffer.getBytes());
    }

    private static ClusterSerializable unmarshal0(ClusterSerializableValue value) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(value.getClassName());
            ClusterSerializable obj = (ClusterSerializable)cls.newInstance();
            obj.readFromBuffer(0, Buffer.buffer((byte[])value.getData()));
            return obj;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load class " + value.getClassName(), e);
        }
    }

    public static class ClusterSerializableValue {
        private final String clsName;
        private final byte[] data;

        public ClusterSerializableValue(String clsName, byte[] data) {
            this.clsName = clsName;
            this.data = data;
        }

        public String getClassName() {
            return this.clsName;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            ClusterSerializableValue value = (ClusterSerializableValue)that;
            return Objects.equals(this.clsName, value.clsName) && Arrays.equals(this.data, value.data);
        }

        public int hashCode() {
            int result = Objects.hash(this.clsName);
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }
    }
}

