/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.hazelcast.impl;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.spi.cluster.hazelcast.impl.ConversionUtils;
import io.vertx.spi.cluster.hazelcast.impl.HandlerCallBackAdapter;
import io.vertx.spi.cluster.hazelcast.impl.HazelcastServerID;
import io.vertx.spi.cluster.hazelcast.impl.VertxExecutorAdapter;
import io.vertx.spi.cluster.hazelcast.impl.VoidHandlerCallBackAdapter;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class HazelcastInternalAsyncMap<K, V>
implements AsyncMap<K, V> {
    private final Vertx vertx;
    private final IMap<K, V> map;

    public HazelcastInternalAsyncMap(Vertx vertx, IMap<K, V> map) {
        this.vertx = vertx;
        this.map = map;
    }

    public void get(K k, Handler<AsyncResult<V>> asyncResultHandler) {
        this.executeAsync((ICompletableFuture)this.map.getAsync(ConversionUtils.convertParam(k)), asyncResultHandler);
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> completionHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.executeAsyncVoid((ICompletableFuture<Void>)((ICompletableFuture)this.map.putAsync(kk, vv)), completionHandler);
    }

    public void putIfAbsent(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.putIfAbsent(kk, HazelcastServerID.convertServerID(vv)))), resultHandler);
    }

    public void put(K k, V v, long ttl, Handler<AsyncResult<Void>> completionHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.executeAsyncVoid((ICompletableFuture<Void>)((ICompletableFuture)this.map.putAsync(kk, vv, ttl, TimeUnit.MILLISECONDS)), completionHandler);
    }

    public void putIfAbsent(K k, V v, long ttl, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.putIfAbsent(kk, HazelcastServerID.convertServerID(vv), ttl, TimeUnit.MILLISECONDS))), resultHandler);
    }

    public void remove(K k, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        this.executeAsync((ICompletableFuture)this.map.removeAsync(kk), resultHandler);
    }

    public void removeIfPresent(K k, V v, Handler<AsyncResult<Boolean>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.remove(kk, vv)), resultHandler);
    }

    public void replace(K k, V v, Handler<AsyncResult<V>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(v);
        this.vertx.executeBlocking(fut -> fut.complete(ConversionUtils.convertReturn(this.map.replace(kk, vv))), resultHandler);
    }

    public void replaceIfPresent(K k, V oldValue, V newValue, Handler<AsyncResult<Boolean>> resultHandler) {
        K kk = ConversionUtils.convertParam(k);
        V vv = ConversionUtils.convertParam(oldValue);
        V vvv = ConversionUtils.convertParam(newValue);
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.replace(kk, vv, vvv)), resultHandler);
    }

    public void clear(Handler<AsyncResult<Void>> resultHandler) {
        this.vertx.executeBlocking(fut -> {
            this.map.clear();
            fut.complete();
        }, resultHandler);
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.vertx.executeBlocking(fut -> fut.complete((Object)this.map.size()), resultHandler);
    }

    private <T> void executeAsync(ICompletableFuture<T> future, Handler<AsyncResult<T>> resultHandler) {
        future.andThen(new HandlerCallBackAdapter<T>(resultHandler), (Executor)VertxExecutorAdapter.getOrCreate(this.vertx.getOrCreateContext()));
    }

    private void executeAsyncVoid(ICompletableFuture<Void> future, Handler<AsyncResult<Void>> resultHandler) {
        future.andThen(new VoidHandlerCallBackAdapter(resultHandler), (Executor)VertxExecutorAdapter.getOrCreate(this.vertx.getOrCreateContext()));
    }
}

