/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.ClientHandler;
import io.vertx.core.http.impl.Http1xPool;
import io.vertx.core.http.impl.Http2Pool;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.VertxHttp2ClientUpgradeCodec;
import io.vertx.core.http.impl.Waiter;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.impl.ChannelProvider;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.ProxyChannelProvider;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLHandshakeException;

public class ConnectionManager {
    static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private final QueueManager wsQM = new QueueManager();
    private final QueueManager requestQM = new QueueManager();
    private final VertxInternal vertx;
    private final SSLHelper sslHelper;
    private final HttpClientOptions options;
    private final HttpClientImpl client;
    private final boolean keepAlive;
    private final boolean pipelining;
    private final int maxWaitQueueSize;
    private final int http2MaxConcurrency;
    private final boolean logEnabled;
    private final ChannelConnector connector;
    private final HttpClientMetrics metrics;

    ConnectionManager(HttpClientImpl client, HttpClientMetrics metrics) {
        this.client = client;
        this.sslHelper = client.getSslHelper();
        this.options = client.getOptions();
        this.vertx = client.getVertx();
        this.keepAlive = client.getOptions().isKeepAlive();
        this.pipelining = client.getOptions().isPipelining();
        this.maxWaitQueueSize = client.getOptions().getMaxWaitQueueSize();
        this.http2MaxConcurrency = this.options.getHttp2MultiplexingLimit() < 1 ? Integer.MAX_VALUE : this.options.getHttp2MultiplexingLimit();
        this.logEnabled = client.getOptions().getLogActivity();
        this.connector = new ChannelConnector();
        this.metrics = metrics;
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    public void getConnectionForWebsocket(int port, String host, Waiter waiter) {
        TargetAddress address = new TargetAddress(host, port);
        ConnQueue connQueue = this.wsQM.getConnQueue(address, HttpVersion.HTTP_1_1);
        connQueue.getConnection(waiter);
    }

    public void getConnectionForRequest(HttpVersion version, int port, String host, Waiter waiter) {
        if (!this.keepAlive && this.pipelining) {
            waiter.handleFailure(new IllegalStateException("Cannot have pipelining with no keep alive"));
        } else {
            TargetAddress address = new TargetAddress(host, port);
            ConnQueue connQueue = this.requestQM.getConnQueue(address, version);
            connQueue.getConnection(waiter);
        }
    }

    public void close() {
        this.wsQM.close();
        this.requestQM.close();
        this.metrics.close();
    }

    private class ChannelConnector {
        private ChannelConnector() {
        }

        protected void connect(final ConnQueue queue, Bootstrap bootstrap, final ContextImpl context, HttpVersion version, String host, int port, Waiter waiter) {
            this.applyConnectionOptions(ConnectionManager.this.options, bootstrap);
            ChannelProvider channelProvider = ConnectionManager.this.options.getProxyOptions() == null || !ConnectionManager.this.options.isSsl() && ConnectionManager.this.options.getProxyOptions().getType() == ProxyType.HTTP ? ChannelProvider.INSTANCE : ProxyChannelProvider.INSTANCE;
            Handler<Channel> channelInitializer = ch -> {
                final ChannelPipeline pipeline = ch.pipeline();
                boolean useAlpn = ConnectionManager.this.options.isUseAlpn();
                if (useAlpn) {
                    SslHandler sslHandler = ConnectionManager.this.sslHelper.createSslHandler(ConnectionManager.this.client.getVertx(), host, port);
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("http/1.1", (Channel)ch, waiter, port, host){
                        final /* synthetic */ Channel val$ch;
                        final /* synthetic */ Waiter val$waiter;
                        final /* synthetic */ int val$port;
                        final /* synthetic */ String val$host;
                        {
                            this.val$ch = channel;
                            this.val$waiter = waiter;
                            this.val$port = n;
                            this.val$host = string;
                            super(x0);
                        }

                        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                            if ("h2".equals(protocol)) {
                                ChannelConnector.this.applyHttp2ConnectionOptions(pipeline);
                                queue.http2Connected(context, this.val$ch, this.val$waiter, false);
                            } else {
                                ChannelConnector.this.applyHttp1xConnectionOptions(queue, this.val$ch.pipeline(), context);
                                HttpVersion fallbackProtocol = "http/1.1".equals(protocol) ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0;
                                queue.fallbackToHttp1x(this.val$ch, context, fallbackProtocol, this.val$port, this.val$host, this.val$waiter);
                            }
                        }
                    }});
                } else {
                    if (ConnectionManager.this.options.isSsl()) {
                        pipeline.addLast("ssl", (ChannelHandler)ConnectionManager.this.sslHelper.createSslHandler(ConnectionManager.this.vertx, host, port));
                    }
                    if (version == HttpVersion.HTTP_2) {
                        if (ConnectionManager.this.options.isHttp2ClearTextUpgrade()) {
                            final HttpClientCodec httpCodec = new HttpClientCodec();
                            VertxHttp2ClientUpgradeCodec upgradeCodec = new VertxHttp2ClientUpgradeCodec(ConnectionManager.this.client.getOptions().getInitialSettings(), (Channel)ch, waiter){
                                final /* synthetic */ Channel val$ch;
                                final /* synthetic */ Waiter val$waiter;
                                {
                                    this.val$ch = channel;
                                    this.val$waiter = waiter;
                                    super(settings);
                                }

                                @Override
                                public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
                                    ChannelConnector.this.applyHttp2ConnectionOptions(pipeline);
                                    queue.http2Connected(context, this.val$ch, this.val$waiter, true);
                                }
                            };
                            HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
                            class UpgradeRequestHandler
                            extends ChannelInboundHandlerAdapter {
                                final /* synthetic */ Channel val$ch;
                                final /* synthetic */ ContextImpl val$context;
                                final /* synthetic */ int val$port;
                                final /* synthetic */ String val$host;
                                final /* synthetic */ Waiter val$waiter;

                                UpgradeRequestHandler() {
                                    this.val$ch = channel;
                                    this.val$context = contextImpl;
                                    this.val$port = n;
                                    this.val$host = string;
                                    this.val$waiter = waiter;
                                }

                                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                    DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
                                    ctx.writeAndFlush((Object)upgradeRequest);
                                    ctx.fireChannelActive();
                                }

                                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                                    super.userEventTriggered(ctx, evt);
                                    ChannelPipeline p = ctx.pipeline();
                                    if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                                        p.remove((ChannelHandler)this);
                                    } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                                        p.remove((ChannelHandler)httpCodec);
                                        p.remove((ChannelHandler)this);
                                        ChannelConnector.this.applyHttp1xConnectionOptions(queue, this.val$ch.pipeline(), this.val$context);
                                        queue.fallbackToHttp1x(this.val$ch, this.val$context, HttpVersion.HTTP_1_1, this.val$port, this.val$host, this.val$waiter);
                                    }
                                }
                            }
                            ch.pipeline().addLast(new ChannelHandler[]{httpCodec, upgradeHandler, new UpgradeRequestHandler()});
                        } else {
                            this.applyHttp2ConnectionOptions(pipeline);
                        }
                    } else {
                        this.applyHttp1xConnectionOptions(queue, pipeline, context);
                    }
                }
            };
            Handler<AsyncResult<Channel>> channelHandler = res -> {
                if (res.succeeded()) {
                    Channel ch = (Channel)res.result();
                    if (ConnectionManager.this.options.isSsl()) {
                        SslHandler sslHandler = (SslHandler)ch.pipeline().get(SslHandler.class);
                        Future fut = sslHandler.handshakeFuture();
                        fut.addListener(fut2 -> {
                            if (fut2.isSuccess()) {
                                if (!ConnectionManager.this.options.isUseAlpn()) {
                                    queue.http1xConnected(version, context, port, host, ch, waiter);
                                }
                            } else {
                                queue.handshakeFailure(context, ch, fut2.cause(), waiter);
                            }
                        });
                    } else if (!ConnectionManager.this.options.isUseAlpn() && ch.pipeline().get(HttpClientUpgradeHandler.class) == null) {
                        if (version == HttpVersion.HTTP_2 && !ConnectionManager.this.options.isHttp2ClearTextUpgrade()) {
                            queue.http2Connected(context, ch, waiter, false);
                        } else {
                            queue.http1xConnected(version, context, port, host, ch, waiter);
                        }
                    }
                } else {
                    queue.connectionFailed(context, null, waiter::handleFailure, res.cause());
                }
            };
            channelProvider.connect(ConnectionManager.this.vertx, bootstrap, ConnectionManager.this.options.getProxyOptions(), host, port, channelInitializer, channelHandler);
        }

        void applyConnectionOptions(HttpClientOptions options, Bootstrap bootstrap) {
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)options.isTcpNoDelay());
            if (options.getSendBufferSize() != -1) {
                bootstrap.option(ChannelOption.SO_SNDBUF, (Object)options.getSendBufferSize());
            }
            if (options.getReceiveBufferSize() != -1) {
                bootstrap.option(ChannelOption.SO_RCVBUF, (Object)options.getReceiveBufferSize());
                bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
            }
            if (options.getSoLinger() != -1) {
                bootstrap.option(ChannelOption.SO_LINGER, (Object)options.getSoLinger());
            }
            if (options.getTrafficClass() != -1) {
                bootstrap.option(ChannelOption.IP_TOS, (Object)options.getTrafficClass());
            }
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.getConnectTimeout());
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)PartialPooledByteBufAllocator.INSTANCE);
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)options.isTcpKeepAlive());
            bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)options.isReuseAddress());
        }

        void applyHttp2ConnectionOptions(ChannelPipeline pipeline) {
            if (ConnectionManager.this.options.getIdleTimeout() > 0) {
                pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, ConnectionManager.this.options.getIdleTimeout()));
            }
        }

        void applyHttp1xConnectionOptions(ConnQueue queue, ChannelPipeline pipeline, ContextImpl context) {
            if (ConnectionManager.this.logEnabled) {
                pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
            }
            pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec(4096, 8192, ConnectionManager.this.options.getMaxChunkSize(), false, false));
            if (ConnectionManager.this.options.isTryUseCompression()) {
                pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(true));
            }
            if (ConnectionManager.this.options.getIdleTimeout() > 0) {
                pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, ConnectionManager.this.options.getIdleTimeout()));
            }
            pipeline.addLast("handler", (ChannelHandler)new ClientHandler(pipeline.channel(), context, queue.mgr.connectionMap));
        }
    }

    static interface Pool<C extends HttpClientConnection> {
        public HttpVersion version();

        public C pollConnection();

        public boolean canCreateConnection(int var1);

        public void closeAllConnections();

        public void recycle(C var1);

        public HttpClientStream createStream(C var1) throws Exception;
    }

    public class ConnQueue {
        private final QueueManager mgr;
        private final TargetAddress address;
        private final Queue<Waiter> waiters = new ArrayDeque<Waiter>();
        private Pool<HttpClientConnection> pool;
        private int connCount;
        private final int maxSize;
        final Object metric;

        ConnQueue(HttpVersion version, QueueManager mgr, TargetAddress address) {
            this.address = address;
            this.mgr = mgr;
            if (version == HttpVersion.HTTP_2) {
                this.maxSize = ConnectionManager.this.options.getHttp2MaxPoolSize();
                this.pool = new Http2Pool(this, ConnectionManager.this.client, ConnectionManager.this.metrics, mgr.connectionMap, ConnectionManager.this.http2MaxConcurrency, ConnectionManager.this.logEnabled, ConnectionManager.this.options.getHttp2MaxPoolSize(), ConnectionManager.this.options.getHttp2ConnectionWindowSize());
            } else {
                this.maxSize = ConnectionManager.this.options.getMaxPoolSize();
                this.pool = new Http1xPool(ConnectionManager.this.client, ConnectionManager.this.metrics, ConnectionManager.this.options, this, mgr.connectionMap, version, ConnectionManager.this.options.getMaxPoolSize());
            }
            this.metric = ConnectionManager.this.metrics.createEndpoint(address.host, address.port, this.maxSize);
        }

        public synchronized void getConnection(Waiter waiter) {
            HttpClientConnection conn = this.pool.pollConnection();
            if (conn != null && conn.isValid()) {
                ContextImpl context = waiter.context;
                if (context == null) {
                    context = conn.getContext();
                } else if (context != conn.getContext()) {
                    log.warn("Reusing a connection with a different context: an HttpClient is probably shared between different Verticles");
                }
                context.runOnContext(v -> this.deliverStream(conn, waiter));
            } else if (this.pool.canCreateConnection(this.connCount)) {
                this.createNewConnection(waiter);
            } else if (ConnectionManager.this.maxWaitQueueSize < 0 || this.waiters.size() < ConnectionManager.this.maxWaitQueueSize) {
                if (ConnectionManager.this.metrics.isEnabled()) {
                    waiter.metric = ConnectionManager.this.metrics.enqueueRequest(this.metric);
                }
                this.waiters.add(waiter);
            } else {
                waiter.handleFailure(new ConnectionPoolTooBusyException("Connection pool reached max wait queue size of " + ConnectionManager.this.maxWaitQueueSize));
            }
        }

        void deliverStream(HttpClientConnection conn, Waiter waiter) {
            if (!conn.isValid()) {
                this.getConnection(waiter);
            } else if (waiter.isCancelled()) {
                this.pool.recycle(conn);
            } else {
                HttpClientStream stream;
                try {
                    stream = this.pool.createStream(conn);
                }
                catch (Exception e) {
                    this.getConnection(waiter);
                    return;
                }
                waiter.handleStream(stream);
            }
        }

        void closeAllConnections() {
            this.pool.closeAllConnections();
        }

        private void createNewConnection(Waiter waiter) {
            ++this.connCount;
            ContextImpl context = waiter.context == null ? ConnectionManager.this.vertx.getOrCreateContext() : waiter.context;
            ConnectionManager.this.sslHelper.validate(ConnectionManager.this.vertx);
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)context.nettyEventLoop());
            bootstrap.channel(NioSocketChannel.class);
            ConnectionManager.this.connector.connect(this, bootstrap, context, this.pool.version(), this.address.host, this.address.port, waiter);
        }

        Waiter getNextWaiter() {
            Waiter waiter = this.waiters.poll();
            if (waiter != null && ConnectionManager.this.metrics.isEnabled()) {
                ConnectionManager.this.metrics.dequeueRequest(this.metric, waiter.metric);
            }
            while (waiter != null && waiter.isCancelled()) {
                waiter = this.waiters.poll();
                if (waiter == null || !ConnectionManager.this.metrics.isEnabled()) continue;
                ConnectionManager.this.metrics.dequeueRequest(this.metric, waiter.metric);
            }
            return waiter;
        }

        public synchronized void connectionClosed() {
            --this.connCount;
            Waiter waiter = this.getNextWaiter();
            if (waiter != null) {
                this.createNewConnection(waiter);
            } else if (this.connCount == 0) {
                this.mgr.queueMap.remove(this.address);
                if (ConnectionManager.this.metrics.isEnabled()) {
                    ConnectionManager.this.metrics.closeEndpoint(this.address.host, this.address.port, this.metric);
                }
            }
        }

        private void handshakeFailure(ContextImpl context, Channel ch, Throwable cause, Waiter waiter) {
            SSLHandshakeException sslException = new SSLHandshakeException("Failed to create SSL connection");
            if (cause != null) {
                sslException.initCause(cause);
            }
            this.connectionFailed(context, ch, waiter::handleFailure, sslException);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fallbackToHttp1x(Channel ch, ContextImpl context, HttpVersion fallbackVersion, int port, String host, Waiter waiter) {
            ConnQueue connQueue = this;
            synchronized (connQueue) {
                this.pool = new Http1xPool(ConnectionManager.this.client, ConnectionManager.this.metrics, ConnectionManager.this.options, this, this.mgr.connectionMap, fallbackVersion, ConnectionManager.this.options.getMaxPoolSize());
            }
            this.http1xConnected(fallbackVersion, context, port, host, ch, waiter);
        }

        private void http1xConnected(HttpVersion version, ContextImpl context, int port, String host, Channel ch, Waiter waiter) {
            context.executeFromIO(() -> ((Http1xPool)this.pool).createConn(version, context, port, host, ch, waiter));
        }

        private void http2Connected(ContextImpl context, Channel ch, Waiter waiter, boolean upgrade) {
            context.executeFromIO(() -> {
                try {
                    ((Http2Pool)this.pool).createConn(context, ch, waiter, upgrade);
                }
                catch (Http2Exception e) {
                    this.connectionFailed(context, ch, waiter::handleFailure, e);
                }
            });
        }

        private void connectionFailed(ContextImpl context, Channel ch, Handler<Throwable> connectionExceptionHandler, Throwable t) {
            Handler<Throwable> exHandler = connectionExceptionHandler == null ? log::error : connectionExceptionHandler;
            context.executeFromIO(() -> {
                this.connectionClosed();
                try {
                    ch.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                exHandler.handle(t);
            });
        }
    }

    static class TargetAddress {
        final String host;
        final int port;

        TargetAddress(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetAddress that = (TargetAddress)o;
            if (this.port != that.port) {
                return false;
            }
            return !(this.host != null ? !this.host.equals(that.host) : that.host != null);
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + this.port;
            return result;
        }
    }

    private class QueueManager {
        private final Map<Channel, HttpClientConnection> connectionMap = new ConcurrentHashMap<Channel, HttpClientConnection>();
        private final Map<TargetAddress, ConnQueue> queueMap = new ConcurrentHashMap<TargetAddress, ConnQueue>();

        private QueueManager() {
        }

        ConnQueue getConnQueue(TargetAddress address, HttpVersion version) {
            return this.queueMap.computeIfAbsent(address, targetAddress -> new ConnQueue(version, this, (TargetAddress)targetAddress));
        }

        public void close() {
            for (ConnQueue queue : this.queueMap.values()) {
                queue.closeAllConnections();
            }
            this.queueMap.clear();
            for (HttpClientConnection conn : this.connectionMap.values()) {
                conn.close();
            }
        }
    }
}

