/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.frame.DataAndMetadataFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import javax.annotation.Nullable;

class RequestFlyweight {
    FrameType frameType;

    RequestFlyweight(FrameType frameType) {
        this.frameType = frameType;
    }

    ByteBuf encode(ByteBufAllocator allocator, int streamId, boolean fragmentFollows, @Nullable ByteBuf metadata, ByteBuf data) {
        return this.encode(allocator, streamId, fragmentFollows, false, false, 0, metadata, data);
    }

    ByteBuf encode(ByteBufAllocator allocator, int streamId, boolean fragmentFollows, boolean complete, boolean next, int requestN, @Nullable ByteBuf metadata, ByteBuf data) {
        int flags = 0;
        if (metadata != null) {
            flags |= 0x100;
        }
        if (fragmentFollows) {
            flags |= 0x80;
        }
        if (complete) {
            flags |= 0x40;
        }
        if (next) {
            flags |= 0x20;
        }
        ByteBuf header = FrameHeaderFlyweight.encode(allocator, streamId, this.frameType, flags);
        if (requestN > 0) {
            header.writeInt(requestN);
        }
        if (metadata != null) {
            return DataAndMetadataFlyweight.encode(allocator, header, metadata, data);
        }
        return DataAndMetadataFlyweight.encodeOnlyData(allocator, header, data);
    }

    ByteBuf data(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderFlyweight.hasMetadata(byteBuf);
        int idx = byteBuf.readerIndex();
        byteBuf.skipBytes(FrameHeaderFlyweight.size());
        ByteBuf data = DataAndMetadataFlyweight.dataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.readerIndex(idx);
        return data;
    }

    ByteBuf metadata(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderFlyweight.hasMetadata(byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderFlyweight.size());
        ByteBuf metadata = DataAndMetadataFlyweight.metadataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.resetReaderIndex();
        return metadata;
    }

    ByteBuf dataWithRequestN(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderFlyweight.hasMetadata(byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderFlyweight.size() + 4);
        ByteBuf data = DataAndMetadataFlyweight.dataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.resetReaderIndex();
        return data;
    }

    ByteBuf metadataWithRequestN(ByteBuf byteBuf) {
        boolean hasMetadata = FrameHeaderFlyweight.hasMetadata(byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderFlyweight.size() + 4);
        ByteBuf metadata = DataAndMetadataFlyweight.metadataWithoutMarking(byteBuf, hasMetadata);
        byteBuf.resetReaderIndex();
        return metadata;
    }

    int initialRequestN(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        int i = byteBuf.skipBytes(FrameHeaderFlyweight.size()).readInt();
        byteBuf.resetReaderIndex();
        return i;
    }
}

