/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.PemReader;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSslServerContext
extends OpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OpenSslServerContext.class);
    private final OpenSslServerSessionContext sessionContext;

    public OpenSslServerContext(File certChainFile, File keyFile) throws SSLException {
        this(certChainFile, keyFile, null);
    }

    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword) throws SSLException {
        this(certChainFile, keyFile, keyPassword, null, null, OpenSslDefaultApplicationProtocolNegotiator.INSTANCE, 0L, 0L);
    }

    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, ApplicationProtocolConfig apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, keyFile, keyPassword, null, ciphers, OpenSslServerContext.toNegotiator(apn, false), sessionCacheSize, sessionTimeout);
    }

    @Deprecated
    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, keyFile, keyPassword, ciphers, OpenSslServerContext.toApplicationProtocolConfig(nextProtocols), sessionCacheSize, sessionTimeout);
    }

    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, ApplicationProtocolConfig config, long sessionCacheSize, long sessionTimeout) throws SSLException {
        this(certChainFile, keyFile, keyPassword, trustManagerFactory, ciphers, OpenSslServerContext.toNegotiator(config, true), sessionCacheSize, sessionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSslServerContext(File certChainFile, File keyFile, String keyPassword, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, OpenSslApplicationProtocolNegotiator apn, long sessionCacheSize, long sessionTimeout) throws SSLException {
        super(ciphers, apn, sessionCacheSize, sessionTimeout, 1);
        OpenSsl.ensureAvailability();
        ObjectUtil.checkNotNull((Object)certChainFile, (String)"certChainFile");
        if (!certChainFile.isFile()) {
            throw new IllegalArgumentException("certChainFile is not a file: " + certChainFile);
        }
        ObjectUtil.checkNotNull((Object)keyFile, (String)"keyFile");
        if (!keyFile.isFile()) {
            throw new IllegalArgumentException("keyPath is not a file: " + keyFile);
        }
        if (keyPassword == null) {
            keyPassword = "";
        }
        boolean success = false;
        try {
            Class<OpenSslContext> clazz = OpenSslContext.class;
            synchronized (OpenSslContext.class) {
                long error;
                SSLContext.setVerify((long)this.ctx, (int)0, (int)10);
                if (!SSLContext.setCertificateChainFile((long)this.ctx, (String)certChainFile.getPath(), (boolean)true) && OpenSsl.isError(error = (long)SSL.getLastErrorNumber())) {
                    String err = SSL.getErrorString((long)error);
                    throw new SSLException("failed to set certificate chain: " + certChainFile + " (" + err + ')');
                }
                try {
                    if (!SSLContext.setCertificate((long)this.ctx, (String)certChainFile.getPath(), (String)keyFile.getPath(), (String)keyPassword, (int)0) && OpenSsl.isError(error = (long)SSL.getLastErrorNumber())) {
                        String err = SSL.getErrorString((long)error);
                        throw new SSLException("failed to set certificate: " + certChainFile + " and " + keyFile + " (" + err + ')');
                    }
                }
                catch (SSLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SSLException("failed to set certificate: " + certChainFile + " and " + keyFile, e);
                }
                try {
                    PrivateKey key;
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(null, null);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    KeyFactory rsaKF = KeyFactory.getInstance("RSA");
                    KeyFactory dsaKF = KeyFactory.getInstance("DSA");
                    ByteBuf encodedKeyBuf = PemReader.readPrivateKey(keyFile);
                    byte[] encodedKey = new byte[encodedKeyBuf.readableBytes()];
                    encodedKeyBuf.readBytes(encodedKey).release();
                    char[] keyPasswordChars = keyPassword.toCharArray();
                    PKCS8EncodedKeySpec encodedKeySpec = OpenSslServerContext.generateKeySpec(keyPasswordChars, encodedKey);
                    try {
                        key = rsaKF.generatePrivate(encodedKeySpec);
                    }
                    catch (InvalidKeySpecException ignore) {
                        key = dsaKF.generatePrivate(encodedKeySpec);
                    }
                    ArrayList<Certificate> certChain = new ArrayList<Certificate>();
                    ByteBuf[] certs = PemReader.readCertificates(certChainFile);
                    try {
                        for (ByteBuf buf : certs) {
                            certChain.add(cf.generateCertificate((InputStream)new ByteBufInputStream(buf)));
                        }
                    }
                    finally {
                        for (ByteBuf buf : certs) {
                            buf.release();
                        }
                    }
                    ks.setKeyEntry("key", key, keyPasswordChars, certChain.toArray(new Certificate[certChain.size()]));
                    if (trustManagerFactory == null) {
                        trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init((KeyStore)null);
                    } else {
                        trustManagerFactory.init(ks);
                    }
                    final X509TrustManager manager = OpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                    SSLContext.setCertVerifyCallback((long)this.ctx, (CertificateVerifier)new CertificateVerifier(){

                        public boolean verify(long ssl, byte[][] chain, String auth) {
                            X509Certificate[] peerCerts = OpenSslContext.certificates(chain);
                            try {
                                manager.checkClientTrusted(peerCerts, auth);
                                return true;
                            }
                            catch (Exception e) {
                                logger.debug("verification of certificate failed", (Throwable)e);
                                return false;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw new SSLException("unable to setup trustmanager", e);
                }
                this.sessionContext = new OpenSslServerSessionContext(this.ctx);
                success = true;
            }
        }
        finally {
            if (!success) {
                this.destroyPools();
            }
        }
        {
            return;
        }
    }

    @Override
    public OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }
}

