/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.netty.client;

import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientHandler
extends SimpleChannelInboundHandler<XxlRpcResponse> {
    private static final Logger logger = LoggerFactory.getLogger(NettyClientHandler.class);
    private XxlRpcInvokerFactory xxlRpcInvokerFactory;

    public NettyClientHandler(XxlRpcInvokerFactory xxlRpcInvokerFactory) {
        this.xxlRpcInvokerFactory = xxlRpcInvokerFactory;
    }

    protected void channelRead0(ChannelHandlerContext ctx, XxlRpcResponse xxlRpcResponse) throws Exception {
        this.xxlRpcInvokerFactory.notifyInvokerFuture(xxlRpcResponse.getRequestId(), xxlRpcResponse);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error(">>>>>>>>>>> xxl-rpc netty client caught exception", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.channel().close();
            logger.debug(">>>>>>>>>>> xxl-rpc netty client close an idle channel.");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

