/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.registry.client;

import com.xxl.registry.client.model.XxlRegistryDataParamVO;
import com.xxl.registry.client.model.XxlRegistryParamVO;
import com.xxl.registry.client.util.BasicHttpUtil;
import com.xxl.registry.client.util.json.BasicJson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlRegistryBaseClient {
    private static Logger logger = LoggerFactory.getLogger(XxlRegistryBaseClient.class);
    private String adminAddress;
    private String accessToken;
    private String biz;
    private String env;
    private List<String> adminAddressArr;

    public XxlRegistryBaseClient(String adminAddress, String accessToken, String biz, String env) {
        this.adminAddress = adminAddress;
        this.accessToken = accessToken;
        this.biz = biz;
        this.env = env;
        if (adminAddress == null || adminAddress.trim().length() == 0) {
            throw new RuntimeException("xxl-registry adminAddress empty");
        }
        if (biz == null || biz.trim().length() < 4 || biz.trim().length() > 255) {
            throw new RuntimeException("xxl-registry biz empty Invalid[4~255]");
        }
        if (env == null || env.trim().length() < 2 || env.trim().length() > 255) {
            throw new RuntimeException("xxl-registry biz env Invalid[2~255]");
        }
        this.adminAddressArr = new ArrayList<String>();
        if (adminAddress.contains(",")) {
            this.adminAddressArr.addAll(Arrays.asList(adminAddress.split(",")));
        } else {
            this.adminAddressArr.add(adminAddress);
        }
    }

    public boolean registry(List<XxlRegistryDataParamVO> registryDataList) {
        if (registryDataList == null || registryDataList.size() == 0) {
            throw new RuntimeException("xxl-registry registryDataList empty");
        }
        for (XxlRegistryDataParamVO registryParam : registryDataList) {
            if (registryParam.getKey() == null || registryParam.getKey().trim().length() < 4 || registryParam.getKey().trim().length() > 255) {
                throw new RuntimeException("xxl-registry registryDataList#key Invalid[4~255]");
            }
            if (registryParam.getValue() != null && registryParam.getValue().trim().length() >= 4 && registryParam.getValue().trim().length() <= 255) continue;
            throw new RuntimeException("xxl-registry registryDataList#value Invalid[4~255]");
        }
        String pathUrl = "/api/registry";
        XxlRegistryParamVO registryParamVO = new XxlRegistryParamVO();
        registryParamVO.setAccessToken(this.accessToken);
        registryParamVO.setBiz(this.biz);
        registryParamVO.setEnv(this.env);
        registryParamVO.setRegistryDataList(registryDataList);
        String paramsJson = BasicJson.toJson(registryParamVO);
        Map<String, Object> respObj = this.requestAndValid(pathUrl, paramsJson, 5);
        return respObj != null;
    }

    private Map<String, Object> requestAndValid(String pathUrl, String requestBody, int timeout) {
        Iterator<String> i$ = this.adminAddressArr.iterator();
        if (i$.hasNext()) {
            String adminAddressUrl = i$.next();
            String finalUrl = adminAddressUrl + pathUrl;
            String responseData = BasicHttpUtil.postBody(finalUrl, requestBody, timeout);
            if (responseData == null) {
                return null;
            }
            Map<String, Object> resopnseMap = null;
            try {
                resopnseMap = BasicJson.parseMap(responseData);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resopnseMap == null || !resopnseMap.containsKey("code") || !"200".equals(String.valueOf(resopnseMap.get("code")))) {
                logger.warn("XxlRegistryBaseClient response fail, responseData={}", (Object)responseData);
                return null;
            }
            return resopnseMap;
        }
        return null;
    }

    public boolean remove(List<XxlRegistryDataParamVO> registryDataList) {
        if (registryDataList == null || registryDataList.size() == 0) {
            throw new RuntimeException("xxl-registry registryDataList empty");
        }
        for (XxlRegistryDataParamVO registryParam : registryDataList) {
            if (registryParam.getKey() == null || registryParam.getKey().trim().length() < 4 || registryParam.getKey().trim().length() > 255) {
                throw new RuntimeException("xxl-registry registryDataList#key Invalid[4~255]");
            }
            if (registryParam.getValue() != null && registryParam.getValue().trim().length() >= 4 && registryParam.getValue().trim().length() <= 255) continue;
            throw new RuntimeException("xxl-registry registryDataList#value Invalid[4~255]");
        }
        String pathUrl = "/api/remove";
        XxlRegistryParamVO registryParamVO = new XxlRegistryParamVO();
        registryParamVO.setAccessToken(this.accessToken);
        registryParamVO.setBiz(this.biz);
        registryParamVO.setEnv(this.env);
        registryParamVO.setRegistryDataList(registryDataList);
        String paramsJson = BasicJson.toJson(registryParamVO);
        Map<String, Object> respObj = this.requestAndValid(pathUrl, paramsJson, 5);
        return respObj != null;
    }

    public Map<String, TreeSet<String>> discovery(Set<String> keys) {
        if (keys == null || keys.size() == 0) {
            throw new RuntimeException("xxl-registry keys empty");
        }
        String pathUrl = "/api/discovery";
        XxlRegistryParamVO registryParamVO = new XxlRegistryParamVO();
        registryParamVO.setAccessToken(this.accessToken);
        registryParamVO.setBiz(this.biz);
        registryParamVO.setEnv(this.env);
        registryParamVO.setKeys(new ArrayList<String>(keys));
        String paramsJson = BasicJson.toJson(registryParamVO);
        Map<String, Object> respObj = this.requestAndValid(pathUrl, paramsJson, 5);
        if (respObj != null && respObj.containsKey("data")) {
            Map data = (Map)respObj.get("data");
            return data;
        }
        return null;
    }

    public boolean monitor(Set<String> keys) {
        if (keys == null || keys.size() == 0) {
            throw new RuntimeException("xxl-registry keys empty");
        }
        String pathUrl = "/api/monitor";
        XxlRegistryParamVO registryParamVO = new XxlRegistryParamVO();
        registryParamVO.setAccessToken(this.accessToken);
        registryParamVO.setBiz(this.biz);
        registryParamVO.setEnv(this.env);
        registryParamVO.setKeys(new ArrayList<String>(keys));
        String paramsJson = BasicJson.toJson(registryParamVO);
        Map<String, Object> respObj = this.requestAndValid(pathUrl, paramsJson, 60);
        return respObj != null;
    }
}

