/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.saml;

import com.stormpath.sdk.impl.saml.DefaultAttributeStatementMappingRule;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.saml.AttributeStatementMappingRule;
import com.stormpath.sdk.saml.AttributeStatementMappingRuleBuilder;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultAttributeStatementMappingRuleBuilder
implements AttributeStatementMappingRuleBuilder {
    private String name;
    private Set<String> accountAttributes;
    private String nameFormat;

    public AttributeStatementMappingRuleBuilder setName(String name) {
        Assert.hasText((String)name, (String)"name argument cannot be null or empty.");
        this.name = name;
        return this;
    }

    public AttributeStatementMappingRuleBuilder setNameFormat(String nameFormat) {
        Assert.hasText((String)nameFormat, (String)"nameFormat argument cannot be null or empty.");
        this.nameFormat = nameFormat;
        return this;
    }

    public AttributeStatementMappingRuleBuilder setAccountAttributes(String ... accountAttributes) {
        Assert.notEmpty((Object[])accountAttributes, (String)"accountAttributes cannot be null or empty.");
        LinkedHashSet<String> names = new LinkedHashSet<String>(accountAttributes.length);
        for (String attrName : accountAttributes) {
            Assert.hasText((String)"individual accountAttributes cannot be null or empty.");
            names.add(attrName);
        }
        this.accountAttributes = names;
        return this;
    }

    public AttributeStatementMappingRuleBuilder setAccountAttributes(Set<String> accountAttributes) {
        Assert.notEmpty(accountAttributes, (String)"accountAttributes cannot be null or empty.");
        this.accountAttributes = accountAttributes;
        return this;
    }

    public AttributeStatementMappingRule build() {
        Assert.hasText((String)this.name, (String)"name argument cannot be null or empty.");
        Assert.notEmpty(this.accountAttributes, (String)"accountAttributes cannot be null or empty.");
        return new DefaultAttributeStatementMappingRule(this.name, this.nameFormat, this.accountAttributes);
    }
}

