/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.saml;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.saml.AttributeStatementMappingRule;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultAttributeStatementMappingRule
implements AttributeStatementMappingRule {
    private final String name;
    private final String nameFormat;
    private final Set<String> accountAttributes;

    public DefaultAttributeStatementMappingRule(String name, String nameFormat, Set<String> accountAttributes) {
        Assert.hasText((String)name, (String)"name argument cannot be null or empty.");
        Assert.notEmpty(accountAttributes, (String)"accountAttributes cannot be null or empty.");
        this.name = name;
        this.accountAttributes = Collections.unmodifiableSet(accountAttributes);
        this.nameFormat = nameFormat != null ? nameFormat : null;
    }

    public DefaultAttributeStatementMappingRule(String name, String nameFormat, String ... accountAttributes) {
        Assert.hasText((String)name, (String)"name argument cannot be null or empty.");
        Assert.notNull((Object)accountAttributes, (String)"accountAttributes cannot be null or empty.");
        LinkedHashSet<String> names = new LinkedHashSet<String>(accountAttributes.length);
        for (String attrName : accountAttributes) {
            Assert.hasText((String)"individual accountAttributes cannot be null or empty.");
            names.add(attrName);
        }
        this.name = name;
        Assert.notEmpty(names, (String)"accountAttributes cannot be null or empty.");
        this.accountAttributes = Collections.unmodifiableSet(names);
        this.nameFormat = nameFormat != null ? nameFormat : null;
    }

    public String getName() {
        return this.name;
    }

    public String getNameFormat() {
        return this.nameFormat;
    }

    public Set<String> getAccountAttributes() {
        return this.accountAttributes;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DefaultAttributeStatementMappingRule) {
            DefaultAttributeStatementMappingRule rule = (DefaultAttributeStatementMappingRule)o;
            return this.name.equals(rule.getName());
        }
        return false;
    }
}

