/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.resource;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.impl.directory.DefaultCustomData;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.DateProperty;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.resource.Auditable;
import com.stormpath.sdk.resource.Extendable;
import java.util.Date;
import java.util.Map;

public abstract class AbstractExtendableInstanceResource
extends AbstractInstanceResource
implements Auditable,
Extendable {
    public static final ResourceReference<CustomData> CUSTOM_DATA = new ResourceReference<CustomData>("customData", CustomData.class);
    public static final DateProperty CREATED_AT = new DateProperty("createdAt");
    public static final DateProperty MODIFIED_AT = new DateProperty("modifiedAt");

    protected AbstractExtendableInstanceResource(InternalDataStore dataStore) {
        super(dataStore);
    }

    protected AbstractExtendableInstanceResource(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore);
        if (properties != null && properties.containsKey(CUSTOM_DATA.getName())) {
            Object object = properties.get(CUSTOM_DATA.getName());
            Assert.isInstanceOf(Map.class, (Object)object);
            CustomData customData = this.getDataStore().instantiate(CustomData.class, (Map)properties.get(CUSTOM_DATA.getName()));
            properties.put(CUSTOM_DATA.getName(), customData);
        }
        this.setProperties(properties);
    }

    public static boolean isExtendableInstanceResource(Map<String, ?> props) {
        return AbstractExtendableInstanceResource.isInstanceResource(props) && props.get(CUSTOM_DATA.getName()) instanceof Map;
    }

    public CustomData getCustomData() {
        if (this.isNew() && this.getResourceProperty(CUSTOM_DATA) == null) {
            this.setProperty(CUSTOM_DATA, (Object)this.getDataStore().instantiate(CustomData.class));
        }
        return this.getResourceProperty(CUSTOM_DATA);
    }

    @Override
    public void save() {
        this.applyCustomDataUpdatesIfNecessary();
        super.save();
    }

    protected void applyCustomDataUpdatesIfNecessary() {
        CustomData customData = this.getCustomData();
        Assert.isInstanceOf(DefaultCustomData.class, (Object)customData);
        DefaultCustomData customDataImpl = (DefaultCustomData)customData;
        if (customDataImpl.isDirty()) {
            if (customDataImpl.hasRemovedProperties()) {
                customDataImpl.deleteRemovedProperties();
            }
            if (customDataImpl.hasNewProperties()) {
                this.setProperty(CUSTOM_DATA, (Object)customData);
            }
        }
    }

    public Date getCreatedAt() {
        return this.getDateProperty(CREATED_AT);
    }

    public Date getModifiedAt() {
        return this.getDateProperty(MODIFIED_AT);
    }
}

