/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.oauth.OAuthPolicy;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultOAuthPolicy
extends AbstractInstanceResource
implements OAuthPolicy {
    static final StringProperty ACCESS_TOKEN_TTL = new StringProperty("accessTokenTtl");
    static final StringProperty REFRESH_TOKEN_TTL = new StringProperty("refreshTokenTtl");
    static final StringProperty TOKEN_ENDPOINT = new StringProperty("tokenEndpoint");
    static final ResourceReference<Application> APPLICATION = new ResourceReference<Application>("application", Application.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultOAuthPolicy.createPropertyDescriptorMap(ACCESS_TOKEN_TTL, REFRESH_TOKEN_TTL, TOKEN_ENDPOINT, APPLICATION, TENANT);

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public DefaultOAuthPolicy(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultOAuthPolicy(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    public String getAccessTokenTtl() {
        return this.getString(ACCESS_TOKEN_TTL);
    }

    public String getRefreshTokenTtl() {
        return this.getString(REFRESH_TOKEN_TTL);
    }

    public String getTokenEndpoint() {
        return this.getString(TOKEN_ENDPOINT);
    }

    public OAuthPolicy setAccessTokenTtl(String accessTokenTtl) {
        Assert.notNull((Object)accessTokenTtl, (String)"accessTokenTtl cannot be null.");
        this.setProperty(ACCESS_TOKEN_TTL, (Object)accessTokenTtl);
        return this;
    }

    public OAuthPolicy setRefreshTokenTtl(String refreshTokenTtl) {
        Assert.notNull((Object)refreshTokenTtl, (String)"refreshTokenTtl cannot be null.");
        this.setProperty(REFRESH_TOKEN_TTL, (Object)refreshTokenTtl);
        return this;
    }

    public Application getApplication() {
        return this.getResourceProperty(APPLICATION);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }
}

