/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.oauth;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.DateProperty;
import com.stormpath.sdk.impl.resource.MapProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.oauth.BaseOAuthToken;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Date;
import java.util.Map;

public abstract class AbstractBaseOAuthToken
extends AbstractInstanceResource
implements BaseOAuthToken {
    static final String ACCOUNT_PROP_NAME = "account";
    static final String APPLICATION_PROP_NAME = "application";
    static final String JWT_PROP_NAME = "jwt";
    static final String TENANT_PROP_NAME = "tenant";
    static final StringProperty JWT = new StringProperty("jwt");
    static final DateProperty CREATED_AT = new DateProperty("created_at");
    static final MapProperty EXPANDED_JWT = new MapProperty("expandedJwt");
    static final ResourceReference<Account> ACCOUNT = new ResourceReference<Account>("account", Account.class);
    static final ResourceReference<Application> APPLICATION = new ResourceReference<Application>("application", Application.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = AbstractBaseOAuthToken.createPropertyDescriptorMap(JWT, ACCOUNT, APPLICATION, TENANT, CREATED_AT);

    public AbstractBaseOAuthToken(InternalDataStore dataStore) {
        super(dataStore);
    }

    public AbstractBaseOAuthToken(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    public Date getCreatedAt() {
        return this.getDateProperty(CREATED_AT);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getJwt() {
        return this.getString(JWT);
    }

    public Account getAccount() {
        return this.getResourceProperty(ACCOUNT);
    }

    public Application getApplication() {
        return this.getResourceProperty(APPLICATION);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public Map<String, Object> getExpandedJwt() {
        return this.getMap(EXPANDED_JWT);
    }
}

