/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.mail;

import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.mail.AbstractEmailTemplate;
import com.stormpath.sdk.impl.resource.MapProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.mail.ModeledEmailTemplate;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultModeledEmailTemplate
extends AbstractEmailTemplate<ModeledEmailTemplate>
implements ModeledEmailTemplate {
    static final MapProperty DEFAULT_MODEL = new MapProperty("defaultModel");
    static final String LINK_BASE_URL = "linkBaseUrl";
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultModeledEmailTemplate.createPropertyDescriptorMap(NAME, DESCRIPTION, FROM_NAME, FROM_EMAIL_ADDRESS, SUBJECT, TEXT_BODY, HTML_BODY, MIME_TYPE, DEFAULT_MODEL);

    public DefaultModeledEmailTemplate(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultModeledEmailTemplate(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Map<String, String> getDefaultModel() {
        return this.getDefaultModel(false);
    }

    public ModeledEmailTemplate setLinkBaseUrl(String linkBaseUrl) {
        Assert.hasText((String)linkBaseUrl, (String)"linkBaseUrl cannot be null or empty");
        Map<String, String> defaultModel = this.getDefaultModel(true);
        defaultModel.put(LINK_BASE_URL, linkBaseUrl);
        this.setProperty(DEFAULT_MODEL, defaultModel);
        return this;
    }

    public String getLinkBaseUrl() {
        Map<String, String> defaultModel = this.getDefaultModel(false);
        if (Collections.isEmpty(defaultModel)) {
            return null;
        }
        return defaultModel.get(LINK_BASE_URL);
    }

    private Map<String, String> getDefaultModel(boolean createIfNotExist) {
        LinkedHashMap defaultModel = this.getMap(DEFAULT_MODEL);
        if (defaultModel == null && createIfNotExist) {
            defaultModel = new LinkedHashMap();
        }
        return defaultModel;
    }

    @Override
    public void save() {
        if (!this.getDefaultModel().containsKey(LINK_BASE_URL)) {
            throw new IllegalStateException("The defaultModel map must contain the 'linkBasedUrl' reserved property.");
        }
        super.save();
    }
}

