/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.jwt.signer;

import com.stormpath.sdk.lang.Assert;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacGenerator {
    private final Charset ENCODING_CHARSET;
    private final String ALGORITHM;

    protected HmacGenerator(String algorithm, Charset charset) {
        Assert.hasText((String)algorithm, (String)"algorithm cannot be null or empty.");
        Assert.notNull((Object)charset, (String)"charset cannot be null or empty.");
        this.ENCODING_CHARSET = charset;
        this.ALGORITHM = algorithm;
    }

    public byte[] computeHmac(String msg, byte[] secretKey) {
        Assert.hasText((String)msg, (String)"msg to digest cannot be null or empty");
        Assert.notNull((Object)secretKey, (String)"secretKey cannot be null.");
        try {
            SecretKeySpec key = new SecretKeySpec(secretKey, this.ALGORITHM);
            Mac mac = Mac.getInstance(this.ALGORITHM);
            mac.init(key);
            return mac.doFinal(msg.getBytes(this.ENCODING_CHARSET));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The algorithm provided is not valid: " + this.ALGORITHM, e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("The calculated SecretKey is not valid for algorithm: " + this.ALGORITHM, e);
        }
    }
}

