/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.jwt.signer;

import com.stormpath.sdk.impl.jwt.signer.HmacGenerator;
import com.stormpath.sdk.impl.jwt.signer.JwtSigner;
import com.stormpath.sdk.impl.util.Base64;
import com.stormpath.sdk.lang.Assert;
import java.nio.charset.Charset;

public class DefaultJwtSigner
implements JwtSigner {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String BASE64_URL_JWT_SIGN_HEADER;
    public final String JWT_SIGN_HEADER;
    private static final char JWT_TOKEN_SEPARATOR = '.';
    private static final String SHA256_ALGORITHM = "HmacSHA256";
    private final HmacGenerator sha256HmacGenerator;
    private final byte[] signingKey;

    public DefaultJwtSigner(String kid, String signingKey) {
        this.JWT_SIGN_HEADER = "{\"alg\":\"HS256\",\"typ\":\"JWT\",\"kid\":\"" + kid + "\"}";
        this.BASE64_URL_JWT_SIGN_HEADER = Base64.encodeBase64URLSafeString(this.JWT_SIGN_HEADER.getBytes(UTF_8));
        this.signingKey = signingKey.getBytes(UTF_8);
        this.sha256HmacGenerator = new HmacGenerator(SHA256_ALGORITHM, UTF_8);
    }

    @Override
    public String sign(String jsonPayload) {
        Assert.hasText((String)jsonPayload, (String)"jsonPayload cannot be null or empty.");
        String base64UrlJsonPayload = Base64.encodeBase64URLSafeString(jsonPayload.getBytes(UTF_8));
        String signature = this.calculateSignature(this.BASE64_URL_JWT_SIGN_HEADER, base64UrlJsonPayload);
        return this.BASE64_URL_JWT_SIGN_HEADER + '.' + base64UrlJsonPayload + '.' + signature;
    }

    @Override
    public String calculateSignature(String base64Header, String base64JsonPayload) {
        String jwsInput = base64Header + '.' + base64JsonPayload;
        byte[] hmac = this.sha256HmacGenerator.computeHmac(jwsInput, this.signingKey);
        return Base64.encodeBase64URLSafeString(hmac);
    }
}

