/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.jwt;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.error.jwt.InvalidJwtException;
import com.stormpath.sdk.impl.jwt.JwtWrapper;
import com.stormpath.sdk.impl.jwt.signer.DefaultJwtSigner;
import com.stormpath.sdk.impl.jwt.signer.JwtSigner;
import com.stormpath.sdk.lang.Assert;

public class JwtSignatureValidator {
    private final JwtSigner jwtSigner;

    public JwtSignatureValidator(ApiKey apiKey) {
        Assert.notNull((Object)apiKey, (String)"apiKey cannot be null.");
        this.jwtSigner = new DefaultJwtSigner(apiKey.getId(), apiKey.getSecret());
    }

    public void validate(JwtWrapper jwtWrapper) throws InvalidJwtException {
        Assert.notNull((Object)jwtWrapper, (String)"jwtWrapper cannot be null.");
        String calculatedSignature = this.jwtSigner.calculateSignature(jwtWrapper.getBase64JwtHeader(), jwtWrapper.getBase64JsonPayload());
        if (jwtWrapper.getBase64JwtSignature().equals(calculatedSignature)) {
            return;
        }
        throw new InvalidJwtException("JWT Signature is invalid.");
    }
}

