/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.idsite;

import com.stormpath.sdk.idsite.Nonce;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import java.util.HashMap;
import java.util.Map;

public class DefaultNonce
implements Nonce {
    public static final StringProperty VALUE = new StringProperty("value");
    private final Map<String, Object> properties;

    public DefaultNonce(String nonceValue) {
        Assert.hasText((String)nonceValue);
        this.properties = new HashMap<String, Object>();
        this.properties.put(VALUE.getName(), nonceValue);
    }

    public DefaultNonce(Map<String, Object> properties) {
        Assert.notEmpty(properties);
        Assert.isTrue((properties.size() == 1 && properties.containsKey(VALUE.getName()) ? 1 : 0) != 0);
        Object value = properties.get(VALUE.getName());
        Assert.isInstanceOf(String.class, (Object)value);
        this.properties = properties;
    }

    public String getValue() {
        return this.properties.get(VALUE.getName()).toString();
    }

    public String getHref() {
        return this.getValue();
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

