/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http;

import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ServletHttpRequest
implements HttpRequest {
    private final HttpServletRequest request;
    private final Map<String, String[]> headers;

    public ServletHttpRequest(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request argument cannot be null.");
        this.request = request;
        this.headers = new LinkedHashMap<String, String[]>();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration values = request.getHeaders(headerName);
                if (values == null) continue;
                ArrayList<String> valueList = new ArrayList<String>();
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    valueList.add(value);
                }
                if (Collections.isEmpty(valueList)) continue;
                String[] valueArray = valueList.toArray(new String[valueList.size()]);
                this.headers.put(headerName, valueArray);
            }
        }
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public String getHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    public HttpMethod getMethod() {
        return HttpMethod.fromName((String)this.request.getMethod());
    }

    public Map<String, String[]> getParameters() {
        return this.request.getParameterMap();
    }

    public String getParameter(String parameterName) {
        return this.request.getParameter(parameterName);
    }

    public String getQueryParameters() {
        return this.request.getQueryString();
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }
}

