/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http;

import com.stormpath.sdk.impl.util.RequestUtils;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Strings;
import java.util.Map;
import java.util.TreeMap;

public class QueryString
extends TreeMap<String, String> {
    public QueryString() {
    }

    public QueryString(Map<String, ?> source) {
        if (!Collections.isEmpty(source)) {
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String sValue = value != null ? String.valueOf(value) : null;
                this.put(key, sValue);
            }
        }
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean canonical) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            String key = RequestUtils.encodeUrl((String)entry.getKey(), false, canonical);
            String value = RequestUtils.encodeUrl((String)entry.getValue(), false, canonical);
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static QueryString create(String query) {
        String[] tokens;
        if (!Strings.hasLength((String)query)) {
            return null;
        }
        QueryString queryString = new QueryString();
        for (String token : tokens = Strings.tokenizeToStringArray((String)query, (String)"&", (boolean)false, (boolean)false)) {
            QueryString.applyKeyValuePair(queryString, token);
        }
        return queryString;
    }

    private static void applyKeyValuePair(QueryString qs, String kv) {
        String[] pair = Strings.split((String)kv, (String)"=");
        if (pair != null) {
            String key = pair[0];
            String value = pair[1] != null ? pair[1] : "";
            qs.put(key, value);
        } else {
            qs.put(kv, null);
        }
    }
}

