/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http;

import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.http.HttpRequestBuilder;
import com.stormpath.sdk.impl.http.DefaultHttpRequest;
import com.stormpath.sdk.lang.Assert;
import java.util.HashMap;
import java.util.Map;

public class DefaultHttpRequestBuilder
implements HttpRequestBuilder {
    private HttpMethod method;
    private Map<String, String[]> headers;
    private Map<String, String[]> parameters;
    private String queryParameters;

    public DefaultHttpRequestBuilder(HttpMethod method) {
        Assert.notNull((Object)method);
        this.method = method;
        this.headers = new HashMap<String, String[]>();
        this.parameters = new HashMap<String, String[]>();
    }

    public HttpRequestBuilder headers(Map<String, String[]> headers) {
        Assert.notNull(headers, (String)"headers cannot be null");
        this.headers = headers;
        return this;
    }

    public HttpRequestBuilder parameters(Map<String, String[]> parameters) {
        Assert.notNull(parameters, (String)"parameters cannot be null");
        this.parameters = parameters;
        return this;
    }

    public HttpRequestBuilder addHeader(String key, String[] value) throws IllegalArgumentException {
        Assert.notNull((Object)key, (String)"key argument is required.");
        Assert.notNull((Object)value, (String)"value argument is required.");
        this.headers.put(key, value);
        return this;
    }

    public HttpRequestBuilder addParameter(String key, String[] value) throws IllegalArgumentException {
        Assert.notNull((Object)key, (String)"key argument is required.");
        Assert.notNull((Object)value, (String)"value argument is required.");
        this.parameters.put(key, value);
        return this;
    }

    public HttpRequestBuilder queryParameters(String queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public HttpRequest build() {
        return new DefaultHttpRequest(this.headers, this.method, this.parameters, this.queryParameters);
    }
}

