/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.group;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupMembership;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.resource.Resource;
import java.util.Map;

public class DefaultGroupMembership
extends AbstractInstanceResource
implements GroupMembership {
    static final ResourceReference<Account> ACCOUNT = new ResourceReference<Account>("account", Account.class);
    static final ResourceReference<Group> GROUP = new ResourceReference<Group>("group", Group.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultGroupMembership.createPropertyDescriptorMap(ACCOUNT, GROUP);

    public DefaultGroupMembership(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroupMembership(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Account getAccount() {
        return this.getResourceProperty(ACCOUNT);
    }

    public Group getGroup() {
        return this.getResourceProperty(GROUP);
    }

    public static GroupMembership create(Account account, Group group, InternalDataStore dataStore) {
        Assert.hasText((String)account.getHref(), (String)"Account does not yet have an 'href'.  You must first persist the account before assigning it to a Group.");
        Assert.hasText((String)group.getHref(), (String)"Group does not yet have an 'href'.  You must first persist the group before assigning accounts to it.");
        GroupMembership groupMembership = (GroupMembership)dataStore.instantiate(GroupMembership.class);
        Assert.isInstanceOf(DefaultGroupMembership.class, (Object)groupMembership, (String)("GroupMembership instance is not an expected " + DefaultGroupMembership.class.getName() + " instance."));
        DefaultGroupMembership dgm = (DefaultGroupMembership)groupMembership;
        dgm.setResourceProperty(GROUP, (Resource)group);
        dgm.setResourceProperty(ACCOUNT, (Resource)account);
        String href = "/groupMemberships";
        return dataStore.create(href, groupMembership);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }
}

